/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.drs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The ARN of the Source Network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceNetwork implements SdkPojo, Serializable, ToCopyableBuilder<SourceNetwork.Builder, SourceNetwork> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(SourceNetwork::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> CFN_STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cfnStackName").getter(getter(SourceNetwork::cfnStackName)).setter(setter(Builder::cfnStackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cfnStackName").build()).build();

    private static final SdkField<RecoveryLifeCycle> LAST_RECOVERY_FIELD = SdkField
            .<RecoveryLifeCycle> builder(MarshallingType.SDK_POJO).memberName("lastRecovery")
            .getter(getter(SourceNetwork::lastRecovery)).setter(setter(Builder::lastRecovery))
            .constructor(RecoveryLifeCycle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRecovery").build()).build();

    private static final SdkField<String> LAUNCHED_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("launchedVpcID").getter(getter(SourceNetwork::launchedVpcID)).setter(setter(Builder::launchedVpcID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedVpcID").build()).build();

    private static final SdkField<String> REPLICATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationStatus").getter(getter(SourceNetwork::replicationStatusAsString))
            .setter(setter(Builder::replicationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatus").build()).build();

    private static final SdkField<String> REPLICATION_STATUS_DETAILS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("replicationStatusDetails").getter(getter(SourceNetwork::replicationStatusDetails))
            .setter(setter(Builder::replicationStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStatusDetails").build())
            .build();

    private static final SdkField<String> SOURCE_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceAccountID").getter(getter(SourceNetwork::sourceAccountID))
            .setter(setter(Builder::sourceAccountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceAccountID").build()).build();

    private static final SdkField<String> SOURCE_NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceNetworkID").getter(getter(SourceNetwork::sourceNetworkID))
            .setter(setter(Builder::sourceNetworkID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceNetworkID").build()).build();

    private static final SdkField<String> SOURCE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceRegion").getter(getter(SourceNetwork::sourceRegion)).setter(setter(Builder::sourceRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceRegion").build()).build();

    private static final SdkField<String> SOURCE_VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceVpcID").getter(getter(SourceNetwork::sourceVpcID)).setter(setter(Builder::sourceVpcID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceVpcID").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(SourceNetwork::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            CFN_STACK_NAME_FIELD, LAST_RECOVERY_FIELD, LAUNCHED_VPC_ID_FIELD, REPLICATION_STATUS_FIELD,
            REPLICATION_STATUS_DETAILS_FIELD, SOURCE_ACCOUNT_ID_FIELD, SOURCE_NETWORK_ID_FIELD, SOURCE_REGION_FIELD,
            SOURCE_VPC_ID_FIELD, TAGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String cfnStackName;

    private final RecoveryLifeCycle lastRecovery;

    private final String launchedVpcID;

    private final String replicationStatus;

    private final String replicationStatusDetails;

    private final String sourceAccountID;

    private final String sourceNetworkID;

    private final String sourceRegion;

    private final String sourceVpcID;

    private final Map<String, String> tags;

    private SourceNetwork(BuilderImpl builder) {
        this.arn = builder.arn;
        this.cfnStackName = builder.cfnStackName;
        this.lastRecovery = builder.lastRecovery;
        this.launchedVpcID = builder.launchedVpcID;
        this.replicationStatus = builder.replicationStatus;
        this.replicationStatusDetails = builder.replicationStatusDetails;
        this.sourceAccountID = builder.sourceAccountID;
        this.sourceNetworkID = builder.sourceNetworkID;
        this.sourceRegion = builder.sourceRegion;
        this.sourceVpcID = builder.sourceVpcID;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The ARN of the Source Network.
     * </p>
     * 
     * @return The ARN of the Source Network.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * CloudFormation stack name that was deployed for recovering the Source Network.
     * </p>
     * 
     * @return CloudFormation stack name that was deployed for recovering the Source Network.
     */
    public final String cfnStackName() {
        return cfnStackName;
    }

    /**
     * <p>
     * An object containing information regarding the last recovery of the Source Network.
     * </p>
     * 
     * @return An object containing information regarding the last recovery of the Source Network.
     */
    public final RecoveryLifeCycle lastRecovery() {
        return lastRecovery;
    }

    /**
     * <p>
     * ID of the recovered VPC following Source Network recovery.
     * </p>
     * 
     * @return ID of the recovered VPC following Source Network recovery.
     */
    public final String launchedVpcID() {
        return launchedVpcID;
    }

    /**
     * <p>
     * Status of Source Network Replication. Possible values: (a) STOPPED - Source Network is not replicating. (b)
     * IN_PROGRESS - Source Network is being replicated. (c) PROTECTED - Source Network was replicated successfully and
     * is being synchronized for changes. (d) ERROR - Source Network replication has failed
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationStatus}
     * will return {@link ReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationStatusAsString}.
     * </p>
     * 
     * @return Status of Source Network Replication. Possible values: (a) STOPPED - Source Network is not replicating.
     *         (b) IN_PROGRESS - Source Network is being replicated. (c) PROTECTED - Source Network was replicated
     *         successfully and is being synchronized for changes. (d) ERROR - Source Network replication has failed
     * @see ReplicationStatus
     */
    public final ReplicationStatus replicationStatus() {
        return ReplicationStatus.fromValue(replicationStatus);
    }

    /**
     * <p>
     * Status of Source Network Replication. Possible values: (a) STOPPED - Source Network is not replicating. (b)
     * IN_PROGRESS - Source Network is being replicated. (c) PROTECTED - Source Network was replicated successfully and
     * is being synchronized for changes. (d) ERROR - Source Network replication has failed
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #replicationStatus}
     * will return {@link ReplicationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #replicationStatusAsString}.
     * </p>
     * 
     * @return Status of Source Network Replication. Possible values: (a) STOPPED - Source Network is not replicating.
     *         (b) IN_PROGRESS - Source Network is being replicated. (c) PROTECTED - Source Network was replicated
     *         successfully and is being synchronized for changes. (d) ERROR - Source Network replication has failed
     * @see ReplicationStatus
     */
    public final String replicationStatusAsString() {
        return replicationStatus;
    }

    /**
     * <p>
     * Error details in case Source Network replication status is ERROR.
     * </p>
     * 
     * @return Error details in case Source Network replication status is ERROR.
     */
    public final String replicationStatusDetails() {
        return replicationStatusDetails;
    }

    /**
     * <p>
     * Account ID containing the VPC protected by the Source Network.
     * </p>
     * 
     * @return Account ID containing the VPC protected by the Source Network.
     */
    public final String sourceAccountID() {
        return sourceAccountID;
    }

    /**
     * <p>
     * Source Network ID.
     * </p>
     * 
     * @return Source Network ID.
     */
    public final String sourceNetworkID() {
        return sourceNetworkID;
    }

    /**
     * <p>
     * Region containing the VPC protected by the Source Network.
     * </p>
     * 
     * @return Region containing the VPC protected by the Source Network.
     */
    public final String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * VPC ID protected by the Source Network.
     * </p>
     * 
     * @return VPC ID protected by the Source Network.
     */
    public final String sourceVpcID() {
        return sourceVpcID;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A list of tags associated with the Source Network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of tags associated with the Source Network.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(cfnStackName());
        hashCode = 31 * hashCode + Objects.hashCode(lastRecovery());
        hashCode = 31 * hashCode + Objects.hashCode(launchedVpcID());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(replicationStatusDetails());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAccountID());
        hashCode = 31 * hashCode + Objects.hashCode(sourceNetworkID());
        hashCode = 31 * hashCode + Objects.hashCode(sourceRegion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceVpcID());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceNetwork)) {
            return false;
        }
        SourceNetwork other = (SourceNetwork) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(cfnStackName(), other.cfnStackName())
                && Objects.equals(lastRecovery(), other.lastRecovery()) && Objects.equals(launchedVpcID(), other.launchedVpcID())
                && Objects.equals(replicationStatusAsString(), other.replicationStatusAsString())
                && Objects.equals(replicationStatusDetails(), other.replicationStatusDetails())
                && Objects.equals(sourceAccountID(), other.sourceAccountID())
                && Objects.equals(sourceNetworkID(), other.sourceNetworkID())
                && Objects.equals(sourceRegion(), other.sourceRegion()) && Objects.equals(sourceVpcID(), other.sourceVpcID())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceNetwork").add("Arn", arn())
                .add("CfnStackName", cfnStackName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastRecovery", lastRecovery()).add("LaunchedVpcID", launchedVpcID())
                .add("ReplicationStatus", replicationStatusAsString())
                .add("ReplicationStatusDetails", replicationStatusDetails() == null ? null : "*** Sensitive Data Redacted ***")
                .add("SourceAccountID", sourceAccountID()).add("SourceNetworkID", sourceNetworkID())
                .add("SourceRegion", sourceRegion()).add("SourceVpcID", sourceVpcID())
                .add("Tags", tags() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "cfnStackName":
            return Optional.ofNullable(clazz.cast(cfnStackName()));
        case "lastRecovery":
            return Optional.ofNullable(clazz.cast(lastRecovery()));
        case "launchedVpcID":
            return Optional.ofNullable(clazz.cast(launchedVpcID()));
        case "replicationStatus":
            return Optional.ofNullable(clazz.cast(replicationStatusAsString()));
        case "replicationStatusDetails":
            return Optional.ofNullable(clazz.cast(replicationStatusDetails()));
        case "sourceAccountID":
            return Optional.ofNullable(clazz.cast(sourceAccountID()));
        case "sourceNetworkID":
            return Optional.ofNullable(clazz.cast(sourceNetworkID()));
        case "sourceRegion":
            return Optional.ofNullable(clazz.cast(sourceRegion()));
        case "sourceVpcID":
            return Optional.ofNullable(clazz.cast(sourceVpcID()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceNetwork, T> g) {
        return obj -> g.apply((SourceNetwork) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceNetwork> {
        /**
         * <p>
         * The ARN of the Source Network.
         * </p>
         * 
         * @param arn
         *        The ARN of the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * CloudFormation stack name that was deployed for recovering the Source Network.
         * </p>
         * 
         * @param cfnStackName
         *        CloudFormation stack name that was deployed for recovering the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cfnStackName(String cfnStackName);

        /**
         * <p>
         * An object containing information regarding the last recovery of the Source Network.
         * </p>
         * 
         * @param lastRecovery
         *        An object containing information regarding the last recovery of the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRecovery(RecoveryLifeCycle lastRecovery);

        /**
         * <p>
         * An object containing information regarding the last recovery of the Source Network.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecoveryLifeCycle.Builder} avoiding the
         * need to create one manually via {@link RecoveryLifeCycle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecoveryLifeCycle.Builder#build()} is called immediately and its
         * result is passed to {@link #lastRecovery(RecoveryLifeCycle)}.
         * 
         * @param lastRecovery
         *        a consumer that will call methods on {@link RecoveryLifeCycle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastRecovery(RecoveryLifeCycle)
         */
        default Builder lastRecovery(Consumer<RecoveryLifeCycle.Builder> lastRecovery) {
            return lastRecovery(RecoveryLifeCycle.builder().applyMutation(lastRecovery).build());
        }

        /**
         * <p>
         * ID of the recovered VPC following Source Network recovery.
         * </p>
         * 
         * @param launchedVpcID
         *        ID of the recovered VPC following Source Network recovery.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchedVpcID(String launchedVpcID);

        /**
         * <p>
         * Status of Source Network Replication. Possible values: (a) STOPPED - Source Network is not replicating. (b)
         * IN_PROGRESS - Source Network is being replicated. (c) PROTECTED - Source Network was replicated successfully
         * and is being synchronized for changes. (d) ERROR - Source Network replication has failed
         * </p>
         * 
         * @param replicationStatus
         *        Status of Source Network Replication. Possible values: (a) STOPPED - Source Network is not
         *        replicating. (b) IN_PROGRESS - Source Network is being replicated. (c) PROTECTED - Source Network was
         *        replicated successfully and is being synchronized for changes. (d) ERROR - Source Network replication
         *        has failed
         * @see ReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationStatus
         */
        Builder replicationStatus(String replicationStatus);

        /**
         * <p>
         * Status of Source Network Replication. Possible values: (a) STOPPED - Source Network is not replicating. (b)
         * IN_PROGRESS - Source Network is being replicated. (c) PROTECTED - Source Network was replicated successfully
         * and is being synchronized for changes. (d) ERROR - Source Network replication has failed
         * </p>
         * 
         * @param replicationStatus
         *        Status of Source Network Replication. Possible values: (a) STOPPED - Source Network is not
         *        replicating. (b) IN_PROGRESS - Source Network is being replicated. (c) PROTECTED - Source Network was
         *        replicated successfully and is being synchronized for changes. (d) ERROR - Source Network replication
         *        has failed
         * @see ReplicationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReplicationStatus
         */
        Builder replicationStatus(ReplicationStatus replicationStatus);

        /**
         * <p>
         * Error details in case Source Network replication status is ERROR.
         * </p>
         * 
         * @param replicationStatusDetails
         *        Error details in case Source Network replication status is ERROR.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder replicationStatusDetails(String replicationStatusDetails);

        /**
         * <p>
         * Account ID containing the VPC protected by the Source Network.
         * </p>
         * 
         * @param sourceAccountID
         *        Account ID containing the VPC protected by the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceAccountID(String sourceAccountID);

        /**
         * <p>
         * Source Network ID.
         * </p>
         * 
         * @param sourceNetworkID
         *        Source Network ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceNetworkID(String sourceNetworkID);

        /**
         * <p>
         * Region containing the VPC protected by the Source Network.
         * </p>
         * 
         * @param sourceRegion
         *        Region containing the VPC protected by the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * VPC ID protected by the Source Network.
         * </p>
         * 
         * @param sourceVpcID
         *        VPC ID protected by the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceVpcID(String sourceVpcID);

        /**
         * <p>
         * A list of tags associated with the Source Network.
         * </p>
         * 
         * @param tags
         *        A list of tags associated with the Source Network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String cfnStackName;

        private RecoveryLifeCycle lastRecovery;

        private String launchedVpcID;

        private String replicationStatus;

        private String replicationStatusDetails;

        private String sourceAccountID;

        private String sourceNetworkID;

        private String sourceRegion;

        private String sourceVpcID;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceNetwork model) {
            arn(model.arn);
            cfnStackName(model.cfnStackName);
            lastRecovery(model.lastRecovery);
            launchedVpcID(model.launchedVpcID);
            replicationStatus(model.replicationStatus);
            replicationStatusDetails(model.replicationStatusDetails);
            sourceAccountID(model.sourceAccountID);
            sourceNetworkID(model.sourceNetworkID);
            sourceRegion(model.sourceRegion);
            sourceVpcID(model.sourceVpcID);
            tags(model.tags);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCfnStackName() {
            return cfnStackName;
        }

        public final void setCfnStackName(String cfnStackName) {
            this.cfnStackName = cfnStackName;
        }

        @Override
        public final Builder cfnStackName(String cfnStackName) {
            this.cfnStackName = cfnStackName;
            return this;
        }

        public final RecoveryLifeCycle.Builder getLastRecovery() {
            return lastRecovery != null ? lastRecovery.toBuilder() : null;
        }

        public final void setLastRecovery(RecoveryLifeCycle.BuilderImpl lastRecovery) {
            this.lastRecovery = lastRecovery != null ? lastRecovery.build() : null;
        }

        @Override
        public final Builder lastRecovery(RecoveryLifeCycle lastRecovery) {
            this.lastRecovery = lastRecovery;
            return this;
        }

        public final String getLaunchedVpcID() {
            return launchedVpcID;
        }

        public final void setLaunchedVpcID(String launchedVpcID) {
            this.launchedVpcID = launchedVpcID;
        }

        @Override
        public final Builder launchedVpcID(String launchedVpcID) {
            this.launchedVpcID = launchedVpcID;
            return this;
        }

        public final String getReplicationStatus() {
            return replicationStatus;
        }

        public final void setReplicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
        }

        @Override
        public final Builder replicationStatus(String replicationStatus) {
            this.replicationStatus = replicationStatus;
            return this;
        }

        @Override
        public final Builder replicationStatus(ReplicationStatus replicationStatus) {
            this.replicationStatus(replicationStatus == null ? null : replicationStatus.toString());
            return this;
        }

        public final String getReplicationStatusDetails() {
            return replicationStatusDetails;
        }

        public final void setReplicationStatusDetails(String replicationStatusDetails) {
            this.replicationStatusDetails = replicationStatusDetails;
        }

        @Override
        public final Builder replicationStatusDetails(String replicationStatusDetails) {
            this.replicationStatusDetails = replicationStatusDetails;
            return this;
        }

        public final String getSourceAccountID() {
            return sourceAccountID;
        }

        public final void setSourceAccountID(String sourceAccountID) {
            this.sourceAccountID = sourceAccountID;
        }

        @Override
        public final Builder sourceAccountID(String sourceAccountID) {
            this.sourceAccountID = sourceAccountID;
            return this;
        }

        public final String getSourceNetworkID() {
            return sourceNetworkID;
        }

        public final void setSourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
        }

        @Override
        public final Builder sourceNetworkID(String sourceNetworkID) {
            this.sourceNetworkID = sourceNetworkID;
            return this;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final String getSourceVpcID() {
            return sourceVpcID;
        }

        public final void setSourceVpcID(String sourceVpcID) {
            this.sourceVpcID = sourceVpcID;
        }

        @Override
        public final Builder sourceVpcID(String sourceVpcID) {
            this.sourceVpcID = sourceVpcID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        @Override
        public SourceNetwork build() {
            return new SourceNetwork(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
