/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum RecoveryInstanceDataReplicationState {
    STOPPED("STOPPED"),
    INITIATING("INITIATING"),
    INITIAL_SYNC("INITIAL_SYNC"),
    BACKLOG("BACKLOG"),
    CREATING_SNAPSHOT("CREATING_SNAPSHOT"),
    CONTINUOUS("CONTINUOUS"),
    PAUSED("PAUSED"),
    RESCAN("RESCAN"),
    STALLED("STALLED"),
    DISCONNECTED("DISCONNECTED"),
    REPLICATION_STATE_NOT_AVAILABLE("REPLICATION_STATE_NOT_AVAILABLE"),
    NOT_STARTED("NOT_STARTED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, RecoveryInstanceDataReplicationState> VALUE_MAP;
    private final String value;

    private RecoveryInstanceDataReplicationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static RecoveryInstanceDataReplicationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<RecoveryInstanceDataReplicationState> knownValues() {
        EnumSet<RecoveryInstanceDataReplicationState> knownValues = EnumSet.allOf(RecoveryInstanceDataReplicationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(RecoveryInstanceDataReplicationState.class, RecoveryInstanceDataReplicationState::toString);
    }
}

