/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.drs.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.drs.model.EC2InstanceState;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceDataReplicationInfo;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceFailback;
import software.amazon.awssdk.services.drs.model.RecoveryInstanceProperties;
import software.amazon.awssdk.services.drs.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryInstance
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryInstance> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(RecoveryInstance.getter(RecoveryInstance::arn)).setter(RecoveryInstance.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<RecoveryInstanceDataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationInfo").getter(RecoveryInstance.getter(RecoveryInstance::dataReplicationInfo)).setter(RecoveryInstance.setter(Builder::dataReplicationInfo)).constructor(RecoveryInstanceDataReplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2InstanceID").getter(RecoveryInstance.getter(RecoveryInstance::ec2InstanceID)).setter(RecoveryInstance.setter(Builder::ec2InstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceID").build()}).build();
    private static final SdkField<String> EC2_INSTANCE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ec2InstanceState").getter(RecoveryInstance.getter(RecoveryInstance::ec2InstanceStateAsString)).setter(RecoveryInstance.setter(Builder::ec2InstanceState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceState").build()}).build();
    private static final SdkField<RecoveryInstanceFailback> FAILBACK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failback").getter(RecoveryInstance.getter(RecoveryInstance::failback)).setter(RecoveryInstance.setter(Builder::failback)).constructor(RecoveryInstanceFailback::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failback").build()}).build();
    private static final SdkField<Boolean> IS_DRILL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isDrill").getter(RecoveryInstance.getter(RecoveryInstance::isDrill)).setter(RecoveryInstance.setter(Builder::isDrill)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isDrill").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobID").getter(RecoveryInstance.getter(RecoveryInstance::jobID)).setter(RecoveryInstance.setter(Builder::jobID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()}).build();
    private static final SdkField<String> POINT_IN_TIME_SNAPSHOT_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("pointInTimeSnapshotDateTime").getter(RecoveryInstance.getter(RecoveryInstance::pointInTimeSnapshotDateTime)).setter(RecoveryInstance.setter(Builder::pointInTimeSnapshotDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pointInTimeSnapshotDateTime").build()}).build();
    private static final SdkField<String> RECOVERY_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recoveryInstanceID").getter(RecoveryInstance.getter(RecoveryInstance::recoveryInstanceID)).setter(RecoveryInstance.setter(Builder::recoveryInstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceID").build()}).build();
    private static final SdkField<RecoveryInstanceProperties> RECOVERY_INSTANCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recoveryInstanceProperties").getter(RecoveryInstance.getter(RecoveryInstance::recoveryInstanceProperties)).setter(RecoveryInstance.setter(Builder::recoveryInstanceProperties)).constructor(RecoveryInstanceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryInstanceProperties").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(RecoveryInstance.getter(RecoveryInstance::sourceServerID)).setter(RecoveryInstance.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(RecoveryInstance.getter(RecoveryInstance::tags)).setter(RecoveryInstance.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_REPLICATION_INFO_FIELD, EC2_INSTANCE_ID_FIELD, EC2_INSTANCE_STATE_FIELD, FAILBACK_FIELD, IS_DRILL_FIELD, JOB_ID_FIELD, POINT_IN_TIME_SNAPSHOT_DATE_TIME_FIELD, RECOVERY_INSTANCE_ID_FIELD, RECOVERY_INSTANCE_PROPERTIES_FIELD, SOURCE_SERVER_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final RecoveryInstanceDataReplicationInfo dataReplicationInfo;
    private final String ec2InstanceID;
    private final String ec2InstanceState;
    private final RecoveryInstanceFailback failback;
    private final Boolean isDrill;
    private final String jobID;
    private final String pointInTimeSnapshotDateTime;
    private final String recoveryInstanceID;
    private final RecoveryInstanceProperties recoveryInstanceProperties;
    private final String sourceServerID;
    private final Map<String, String> tags;

    private RecoveryInstance(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.ec2InstanceID = builder.ec2InstanceID;
        this.ec2InstanceState = builder.ec2InstanceState;
        this.failback = builder.failback;
        this.isDrill = builder.isDrill;
        this.jobID = builder.jobID;
        this.pointInTimeSnapshotDateTime = builder.pointInTimeSnapshotDateTime;
        this.recoveryInstanceID = builder.recoveryInstanceID;
        this.recoveryInstanceProperties = builder.recoveryInstanceProperties;
        this.sourceServerID = builder.sourceServerID;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final RecoveryInstanceDataReplicationInfo dataReplicationInfo() {
        return this.dataReplicationInfo;
    }

    public final String ec2InstanceID() {
        return this.ec2InstanceID;
    }

    public final EC2InstanceState ec2InstanceState() {
        return EC2InstanceState.fromValue(this.ec2InstanceState);
    }

    public final String ec2InstanceStateAsString() {
        return this.ec2InstanceState;
    }

    public final RecoveryInstanceFailback failback() {
        return this.failback;
    }

    public final Boolean isDrill() {
        return this.isDrill;
    }

    public final String jobID() {
        return this.jobID;
    }

    public final String pointInTimeSnapshotDateTime() {
        return this.pointInTimeSnapshotDateTime;
    }

    public final String recoveryInstanceID() {
        return this.recoveryInstanceID;
    }

    public final RecoveryInstanceProperties recoveryInstanceProperties() {
        return this.recoveryInstanceProperties;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2InstanceStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failback());
        hashCode = 31 * hashCode + Objects.hashCode(this.isDrill());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobID());
        hashCode = 31 * hashCode + Objects.hashCode(this.pointInTimeSnapshotDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryInstanceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryInstance)) {
            return false;
        }
        RecoveryInstance other = (RecoveryInstance)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataReplicationInfo(), other.dataReplicationInfo()) && Objects.equals(this.ec2InstanceID(), other.ec2InstanceID()) && Objects.equals(this.ec2InstanceStateAsString(), other.ec2InstanceStateAsString()) && Objects.equals(this.failback(), other.failback()) && Objects.equals(this.isDrill(), other.isDrill()) && Objects.equals(this.jobID(), other.jobID()) && Objects.equals(this.pointInTimeSnapshotDateTime(), other.pointInTimeSnapshotDateTime()) && Objects.equals(this.recoveryInstanceID(), other.recoveryInstanceID()) && Objects.equals(this.recoveryInstanceProperties(), other.recoveryInstanceProperties()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"RecoveryInstance").add("Arn", (Object)this.arn()).add("DataReplicationInfo", (Object)this.dataReplicationInfo()).add("Ec2InstanceID", (Object)this.ec2InstanceID()).add("Ec2InstanceState", (Object)this.ec2InstanceStateAsString()).add("Failback", (Object)this.failback()).add("IsDrill", (Object)this.isDrill()).add("JobID", (Object)this.jobID()).add("PointInTimeSnapshotDateTime", (Object)this.pointInTimeSnapshotDateTime()).add("RecoveryInstanceID", (Object)this.recoveryInstanceID()).add("RecoveryInstanceProperties", (Object)this.recoveryInstanceProperties()).add("SourceServerID", (Object)this.sourceServerID()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "dataReplicationInfo": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationInfo()));
            }
            case "ec2InstanceID": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceID()));
            }
            case "ec2InstanceState": {
                return Optional.ofNullable(clazz.cast(this.ec2InstanceStateAsString()));
            }
            case "failback": {
                return Optional.ofNullable(clazz.cast(this.failback()));
            }
            case "isDrill": {
                return Optional.ofNullable(clazz.cast(this.isDrill()));
            }
            case "jobID": {
                return Optional.ofNullable(clazz.cast(this.jobID()));
            }
            case "pointInTimeSnapshotDateTime": {
                return Optional.ofNullable(clazz.cast(this.pointInTimeSnapshotDateTime()));
            }
            case "recoveryInstanceID": {
                return Optional.ofNullable(clazz.cast(this.recoveryInstanceID()));
            }
            case "recoveryInstanceProperties": {
                return Optional.ofNullable(clazz.cast(this.recoveryInstanceProperties()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryInstance, T> g) {
        return obj -> g.apply((RecoveryInstance)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private RecoveryInstanceDataReplicationInfo dataReplicationInfo;
        private String ec2InstanceID;
        private String ec2InstanceState;
        private RecoveryInstanceFailback failback;
        private Boolean isDrill;
        private String jobID;
        private String pointInTimeSnapshotDateTime;
        private String recoveryInstanceID;
        private RecoveryInstanceProperties recoveryInstanceProperties;
        private String sourceServerID;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryInstance model) {
            this.arn(model.arn);
            this.dataReplicationInfo(model.dataReplicationInfo);
            this.ec2InstanceID(model.ec2InstanceID);
            this.ec2InstanceState(model.ec2InstanceState);
            this.failback(model.failback);
            this.isDrill(model.isDrill);
            this.jobID(model.jobID);
            this.pointInTimeSnapshotDateTime(model.pointInTimeSnapshotDateTime);
            this.recoveryInstanceID(model.recoveryInstanceID);
            this.recoveryInstanceProperties(model.recoveryInstanceProperties);
            this.sourceServerID(model.sourceServerID);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final RecoveryInstanceDataReplicationInfo.Builder getDataReplicationInfo() {
            return this.dataReplicationInfo != null ? this.dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(RecoveryInstanceDataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder dataReplicationInfo(RecoveryInstanceDataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final String getEc2InstanceID() {
            return this.ec2InstanceID;
        }

        public final void setEc2InstanceID(String ec2InstanceID) {
            this.ec2InstanceID = ec2InstanceID;
        }

        @Override
        @Transient
        public final Builder ec2InstanceID(String ec2InstanceID) {
            this.ec2InstanceID = ec2InstanceID;
            return this;
        }

        public final String getEc2InstanceState() {
            return this.ec2InstanceState;
        }

        public final void setEc2InstanceState(String ec2InstanceState) {
            this.ec2InstanceState = ec2InstanceState;
        }

        @Override
        @Transient
        public final Builder ec2InstanceState(String ec2InstanceState) {
            this.ec2InstanceState = ec2InstanceState;
            return this;
        }

        @Override
        @Transient
        public final Builder ec2InstanceState(EC2InstanceState ec2InstanceState) {
            this.ec2InstanceState(ec2InstanceState == null ? null : ec2InstanceState.toString());
            return this;
        }

        public final RecoveryInstanceFailback.Builder getFailback() {
            return this.failback != null ? this.failback.toBuilder() : null;
        }

        public final void setFailback(RecoveryInstanceFailback.BuilderImpl failback) {
            this.failback = failback != null ? failback.build() : null;
        }

        @Override
        @Transient
        public final Builder failback(RecoveryInstanceFailback failback) {
            this.failback = failback;
            return this;
        }

        public final Boolean getIsDrill() {
            return this.isDrill;
        }

        public final void setIsDrill(Boolean isDrill) {
            this.isDrill = isDrill;
        }

        @Override
        @Transient
        public final Builder isDrill(Boolean isDrill) {
            this.isDrill = isDrill;
            return this;
        }

        public final String getJobID() {
            return this.jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        @Transient
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        public final String getPointInTimeSnapshotDateTime() {
            return this.pointInTimeSnapshotDateTime;
        }

        public final void setPointInTimeSnapshotDateTime(String pointInTimeSnapshotDateTime) {
            this.pointInTimeSnapshotDateTime = pointInTimeSnapshotDateTime;
        }

        @Override
        @Transient
        public final Builder pointInTimeSnapshotDateTime(String pointInTimeSnapshotDateTime) {
            this.pointInTimeSnapshotDateTime = pointInTimeSnapshotDateTime;
            return this;
        }

        public final String getRecoveryInstanceID() {
            return this.recoveryInstanceID;
        }

        public final void setRecoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
        }

        @Override
        @Transient
        public final Builder recoveryInstanceID(String recoveryInstanceID) {
            this.recoveryInstanceID = recoveryInstanceID;
            return this;
        }

        public final RecoveryInstanceProperties.Builder getRecoveryInstanceProperties() {
            return this.recoveryInstanceProperties != null ? this.recoveryInstanceProperties.toBuilder() : null;
        }

        public final void setRecoveryInstanceProperties(RecoveryInstanceProperties.BuilderImpl recoveryInstanceProperties) {
            this.recoveryInstanceProperties = recoveryInstanceProperties != null ? recoveryInstanceProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder recoveryInstanceProperties(RecoveryInstanceProperties recoveryInstanceProperties) {
            this.recoveryInstanceProperties = recoveryInstanceProperties;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        @Transient
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public RecoveryInstance build() {
            return new RecoveryInstance(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryInstance> {
        public Builder arn(String var1);

        public Builder dataReplicationInfo(RecoveryInstanceDataReplicationInfo var1);

        default public Builder dataReplicationInfo(Consumer<RecoveryInstanceDataReplicationInfo.Builder> dataReplicationInfo) {
            return this.dataReplicationInfo((RecoveryInstanceDataReplicationInfo)((RecoveryInstanceDataReplicationInfo.Builder)RecoveryInstanceDataReplicationInfo.builder().applyMutation(dataReplicationInfo)).build());
        }

        public Builder ec2InstanceID(String var1);

        public Builder ec2InstanceState(String var1);

        public Builder ec2InstanceState(EC2InstanceState var1);

        public Builder failback(RecoveryInstanceFailback var1);

        default public Builder failback(Consumer<RecoveryInstanceFailback.Builder> failback) {
            return this.failback((RecoveryInstanceFailback)((RecoveryInstanceFailback.Builder)RecoveryInstanceFailback.builder().applyMutation(failback)).build());
        }

        public Builder isDrill(Boolean var1);

        public Builder jobID(String var1);

        public Builder pointInTimeSnapshotDateTime(String var1);

        public Builder recoveryInstanceID(String var1);

        public Builder recoveryInstanceProperties(RecoveryInstanceProperties var1);

        default public Builder recoveryInstanceProperties(Consumer<RecoveryInstanceProperties.Builder> recoveryInstanceProperties) {
            return this.recoveryInstanceProperties((RecoveryInstanceProperties)((RecoveryInstanceProperties.Builder)RecoveryInstanceProperties.builder().applyMutation(recoveryInstanceProperties)).build());
        }

        public Builder sourceServerID(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

