/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticRequest;
import software.amazon.awssdk.services.docdbelastic.model.StringListCopier;
import software.amazon.awssdk.services.docdbelastic.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RestoreClusterFromSnapshotRequest
extends DocDbElasticRequest
implements ToCopyableBuilder<Builder, RestoreClusterFromSnapshotRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(RestoreClusterFromSnapshotRequest.getter(RestoreClusterFromSnapshotRequest::clusterName)).setter(RestoreClusterFromSnapshotRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("kmsKeyId").getter(RestoreClusterFromSnapshotRequest.getter(RestoreClusterFromSnapshotRequest::kmsKeyId)).setter(RestoreClusterFromSnapshotRequest.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsKeyId").build()}).build();
    private static final SdkField<Integer> SHARD_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("shardCapacity").getter(RestoreClusterFromSnapshotRequest.getter(RestoreClusterFromSnapshotRequest::shardCapacity)).setter(RestoreClusterFromSnapshotRequest.setter(Builder::shardCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardCapacity").build()}).build();
    private static final SdkField<Integer> SHARD_INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("shardInstanceCount").getter(RestoreClusterFromSnapshotRequest.getter(RestoreClusterFromSnapshotRequest::shardInstanceCount)).setter(RestoreClusterFromSnapshotRequest.setter(Builder::shardInstanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shardInstanceCount").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("snapshotArn").getter(RestoreClusterFromSnapshotRequest.getter(RestoreClusterFromSnapshotRequest::snapshotArn)).setter(RestoreClusterFromSnapshotRequest.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("snapshotArn").build()}).build();
    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subnetIds").getter(RestoreClusterFromSnapshotRequest.getter(RestoreClusterFromSnapshotRequest::subnetIds)).setter(RestoreClusterFromSnapshotRequest.setter(Builder::subnetIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subnetIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(RestoreClusterFromSnapshotRequest.getter(RestoreClusterFromSnapshotRequest::tags)).setter(RestoreClusterFromSnapshotRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> VPC_SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("vpcSecurityGroupIds").getter(RestoreClusterFromSnapshotRequest.getter(RestoreClusterFromSnapshotRequest::vpcSecurityGroupIds)).setter(RestoreClusterFromSnapshotRequest.setter(Builder::vpcSecurityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcSecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, KMS_KEY_ID_FIELD, SHARD_CAPACITY_FIELD, SHARD_INSTANCE_COUNT_FIELD, SNAPSHOT_ARN_FIELD, SUBNET_IDS_FIELD, TAGS_FIELD, VPC_SECURITY_GROUP_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusterName", CLUSTER_NAME_FIELD);
            this.put("kmsKeyId", KMS_KEY_ID_FIELD);
            this.put("shardCapacity", SHARD_CAPACITY_FIELD);
            this.put("shardInstanceCount", SHARD_INSTANCE_COUNT_FIELD);
            this.put("snapshotArn", SNAPSHOT_ARN_FIELD);
            this.put("subnetIds", SUBNET_IDS_FIELD);
            this.put("tags", TAGS_FIELD);
            this.put("vpcSecurityGroupIds", VPC_SECURITY_GROUP_IDS_FIELD);
        }
    });
    private final String clusterName;
    private final String kmsKeyId;
    private final Integer shardCapacity;
    private final Integer shardInstanceCount;
    private final String snapshotArn;
    private final List<String> subnetIds;
    private final Map<String, String> tags;
    private final List<String> vpcSecurityGroupIds;

    private RestoreClusterFromSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.kmsKeyId = builder.kmsKeyId;
        this.shardCapacity = builder.shardCapacity;
        this.shardInstanceCount = builder.shardInstanceCount;
        this.snapshotArn = builder.snapshotArn;
        this.subnetIds = builder.subnetIds;
        this.tags = builder.tags;
        this.vpcSecurityGroupIds = builder.vpcSecurityGroupIds;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Integer shardCapacity() {
        return this.shardCapacity;
    }

    public final Integer shardInstanceCount() {
        return this.shardInstanceCount;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final boolean hasSubnetIds() {
        return this.subnetIds != null && !(this.subnetIds instanceof SdkAutoConstructList);
    }

    public final List<String> subnetIds() {
        return this.subnetIds;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final boolean hasVpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds != null && !(this.vpcSecurityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> vpcSecurityGroupIds() {
        return this.vpcSecurityGroupIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardInstanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnetIds() ? this.subnetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreClusterFromSnapshotRequest)) {
            return false;
        }
        RestoreClusterFromSnapshotRequest other = (RestoreClusterFromSnapshotRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.shardCapacity(), other.shardCapacity()) && Objects.equals(this.shardInstanceCount(), other.shardInstanceCount()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && this.hasSubnetIds() == other.hasSubnetIds() && Objects.equals(this.subnetIds(), other.subnetIds()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && this.hasVpcSecurityGroupIds() == other.hasVpcSecurityGroupIds() && Objects.equals(this.vpcSecurityGroupIds(), other.vpcSecurityGroupIds());
    }

    public final String toString() {
        return ToString.builder((String)"RestoreClusterFromSnapshotRequest").add("ClusterName", (Object)this.clusterName()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ShardCapacity", (Object)this.shardCapacity()).add("ShardInstanceCount", (Object)this.shardInstanceCount()).add("SnapshotArn", (Object)this.snapshotArn()).add("SubnetIds", this.hasSubnetIds() ? this.subnetIds() : null).add("Tags", this.hasTags() ? this.tags() : null).add("VpcSecurityGroupIds", this.hasVpcSecurityGroupIds() ? this.vpcSecurityGroupIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "kmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "shardCapacity": {
                return Optional.ofNullable(clazz.cast(this.shardCapacity()));
            }
            case "shardInstanceCount": {
                return Optional.ofNullable(clazz.cast(this.shardInstanceCount()));
            }
            case "snapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "subnetIds": {
                return Optional.ofNullable(clazz.cast(this.subnetIds()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "vpcSecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroupIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<RestoreClusterFromSnapshotRequest, T> g) {
        return obj -> g.apply((RestoreClusterFromSnapshotRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbElasticRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String kmsKeyId;
        private Integer shardCapacity;
        private Integer shardInstanceCount;
        private String snapshotArn;
        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<String> vpcSecurityGroupIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreClusterFromSnapshotRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.kmsKeyId(model.kmsKeyId);
            this.shardCapacity(model.shardCapacity);
            this.shardInstanceCount(model.shardInstanceCount);
            this.snapshotArn(model.snapshotArn);
            this.subnetIds(model.subnetIds);
            this.tags(model.tags);
            this.vpcSecurityGroupIds(model.vpcSecurityGroupIds);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Integer getShardCapacity() {
            return this.shardCapacity;
        }

        public final void setShardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
        }

        @Override
        public final Builder shardCapacity(Integer shardCapacity) {
            this.shardCapacity = shardCapacity;
            return this;
        }

        public final Integer getShardInstanceCount() {
            return this.shardInstanceCount;
        }

        public final void setShardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
        }

        @Override
        public final Builder shardInstanceCount(Integer shardInstanceCount) {
            this.shardInstanceCount = shardInstanceCount;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final Collection<String> getSubnetIds() {
            if (this.subnetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.subnetIds;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = StringListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Collection<String> getVpcSecurityGroupIds() {
            if (this.vpcSecurityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.vpcSecurityGroupIds;
        }

        public final void setVpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
        }

        @Override
        public final Builder vpcSecurityGroupIds(Collection<String> vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds = StringListCopier.copy(vpcSecurityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcSecurityGroupIds(String ... vpcSecurityGroupIds) {
            this.vpcSecurityGroupIds(Arrays.asList(vpcSecurityGroupIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RestoreClusterFromSnapshotRequest build() {
            return new RestoreClusterFromSnapshotRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DocDbElasticRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RestoreClusterFromSnapshotRequest> {
        public Builder clusterName(String var1);

        public Builder kmsKeyId(String var1);

        public Builder shardCapacity(Integer var1);

        public Builder shardInstanceCount(Integer var1);

        public Builder snapshotArn(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder vpcSecurityGroupIds(Collection<String> var1);

        public Builder vpcSecurityGroupIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

