/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdbelastic;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticClient;
import software.amazon.awssdk.services.docdbelastic.DocDbElasticServiceClientConfiguration;
import software.amazon.awssdk.services.docdbelastic.model.AccessDeniedException;
import software.amazon.awssdk.services.docdbelastic.model.ConflictException;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.CreateClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.DeleteClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticException;
import software.amazon.awssdk.services.docdbelastic.model.DocDbElasticRequest;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.GetClusterSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.InternalServerException;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListClusterSnapshotsResponse;
import software.amazon.awssdk.services.docdbelastic.model.ListClustersRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListClustersResponse;
import software.amazon.awssdk.services.docdbelastic.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.ResourceNotFoundException;
import software.amazon.awssdk.services.docdbelastic.model.RestoreClusterFromSnapshotRequest;
import software.amazon.awssdk.services.docdbelastic.model.RestoreClusterFromSnapshotResponse;
import software.amazon.awssdk.services.docdbelastic.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.docdbelastic.model.TagResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.TagResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.ThrottlingException;
import software.amazon.awssdk.services.docdbelastic.model.UntagResourceRequest;
import software.amazon.awssdk.services.docdbelastic.model.UntagResourceResponse;
import software.amazon.awssdk.services.docdbelastic.model.UpdateClusterRequest;
import software.amazon.awssdk.services.docdbelastic.model.UpdateClusterResponse;
import software.amazon.awssdk.services.docdbelastic.model.ValidationException;
import software.amazon.awssdk.services.docdbelastic.paginators.ListClusterSnapshotsIterable;
import software.amazon.awssdk.services.docdbelastic.paginators.ListClustersIterable;
import software.amazon.awssdk.services.docdbelastic.transform.CreateClusterRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.CreateClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.DeleteClusterRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.DeleteClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.GetClusterRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.GetClusterSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.ListClusterSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.ListClustersRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.RestoreClusterFromSnapshotRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.docdbelastic.transform.UpdateClusterRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultDocDbElasticClient
implements DocDbElasticClient {
    private static final Logger log = Logger.loggerFor(DefaultDocDbElasticClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final DocDbElasticServiceClientConfiguration serviceClientConfiguration;

    protected DefaultDocDbElasticClient(DocDbElasticServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterResponse createCluster(CreateClusterRequest createClusterRequest) throws ThrottlingException, ValidationException, ServiceQuotaExceededException, ConflictException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, createClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateCluster");
            CreateClusterResponse createClusterResponse = (CreateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$createCluster$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateClusterSnapshotResponse createClusterSnapshot(CreateClusterSnapshotRequest createClusterSnapshotRequest) throws ThrottlingException, ValidationException, ServiceQuotaExceededException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateClusterSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, createClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateClusterSnapshot");
            CreateClusterSnapshotResponse createClusterSnapshotResponse = (CreateClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateClusterSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$createClusterSnapshot$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterResponse deleteCluster(DeleteClusterRequest deleteClusterRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, deleteClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteCluster");
            DeleteClusterResponse deleteClusterResponse = (DeleteClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$deleteCluster$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteClusterSnapshotResponse deleteClusterSnapshot(DeleteClusterSnapshotRequest deleteClusterSnapshotRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteClusterSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, deleteClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteClusterSnapshot");
            DeleteClusterSnapshotResponse deleteClusterSnapshotResponse = (DeleteClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteClusterSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$deleteClusterSnapshot$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetClusterResponse getCluster(GetClusterRequest getClusterRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, getClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetCluster");
            GetClusterResponse getClusterResponse = (GetClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$getCluster$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetClusterSnapshotResponse getClusterSnapshot(GetClusterSnapshotRequest getClusterSnapshotRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetClusterSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, getClusterSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetClusterSnapshot");
            GetClusterSnapshotResponse getClusterSnapshotResponse = (GetClusterSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetClusterSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getClusterSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetClusterSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getClusterSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$getClusterSnapshot$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClusterSnapshotsResponse listClusterSnapshots(ListClusterSnapshotsRequest listClusterSnapshotsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClusterSnapshotsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, listClusterSnapshotsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusterSnapshots");
            ListClusterSnapshotsResponse listClusterSnapshotsResponse = (ListClusterSnapshotsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusterSnapshots").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClusterSnapshotsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClusterSnapshotsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClusterSnapshotsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$listClusterSnapshots$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListClusterSnapshotsIterable listClusterSnapshotsPaginator(ListClusterSnapshotsRequest listClusterSnapshotsRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return new ListClusterSnapshotsIterable(this, this.applyPaginatorUserAgent(listClusterSnapshotsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListClustersResponse listClusters(ListClustersRequest listClustersRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListClustersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, listClustersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListClusters");
            ListClustersResponse listClustersResponse = (ListClustersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListClusters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listClustersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListClustersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listClustersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$listClusters$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListClustersIterable listClustersPaginator(ListClustersRequest listClustersRequest) throws ThrottlingException, ValidationException, InternalServerException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        return new ListClustersIterable(this, this.applyPaginatorUserAgent(listClustersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$listTagsForResource$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestoreClusterFromSnapshotResponse restoreClusterFromSnapshot(RestoreClusterFromSnapshotRequest restoreClusterFromSnapshotRequest) throws ThrottlingException, ValidationException, ServiceQuotaExceededException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, RestoreClusterFromSnapshotResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, restoreClusterFromSnapshotRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"RestoreClusterFromSnapshot");
            RestoreClusterFromSnapshotResponse restoreClusterFromSnapshotResponse = (RestoreClusterFromSnapshotResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("RestoreClusterFromSnapshot").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)restoreClusterFromSnapshotRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new RestoreClusterFromSnapshotRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return restoreClusterFromSnapshotResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$restoreClusterFromSnapshot$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$tagResource$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ThrottlingException, ValidationException, InternalServerException, ResourceNotFoundException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$untagResource$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateClusterResponse updateCluster(UpdateClusterRequest updateClusterRequest) throws ThrottlingException, ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, DocDbElasticException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateClusterResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultDocDbElasticClient.resolveMetricPublishers(this.clientConfiguration, updateClusterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"DocDB Elastic");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateCluster");
            UpdateClusterResponse updateClusterResponse = (UpdateClusterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateCluster").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateClusterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateClusterRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateClusterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultDocDbElasticClient.lambda$updateCluster$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private <T extends DocDbElasticRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.20.51").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((DocDbElasticRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public final String serviceName() {
        return "docdb-elastic";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(DocDbElasticException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build());
    }

    @Override
    public final DocDbElasticServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$updateCluster$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$restoreClusterFromSnapshot$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusters$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listClusterSnapshots$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getClusterSnapshot$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getCluster$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteClusterSnapshot$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteCluster$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createClusterSnapshot$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createCluster$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

