/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.docdb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.docdb.model.DocDbResponse;
import software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOption;
import software.amazon.awssdk.services.docdb.model.OrderableDBInstanceOptionsListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeOrderableDbInstanceOptionsResponse
extends DocDbResponse
implements ToCopyableBuilder<Builder, DescribeOrderableDbInstanceOptionsResponse> {
    private static final SdkField<List<OrderableDBInstanceOption>> ORDERABLE_DB_INSTANCE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OrderableDBInstanceOptions").getter(DescribeOrderableDbInstanceOptionsResponse.getter(DescribeOrderableDbInstanceOptionsResponse::orderableDBInstanceOptions)).setter(DescribeOrderableDbInstanceOptionsResponse.setter(Builder::orderableDBInstanceOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableDBInstanceOptions").build(), ListTrait.builder().memberLocationName("OrderableDBInstanceOption").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OrderableDBInstanceOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderableDBInstanceOption").build()}).build()).build()}).build();
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeOrderableDbInstanceOptionsResponse.getter(DescribeOrderableDbInstanceOptionsResponse::marker)).setter(DescribeOrderableDbInstanceOptionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDERABLE_DB_INSTANCE_OPTIONS_FIELD, MARKER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeOrderableDbInstanceOptionsResponse.memberNameToFieldInitializer();
    private final List<OrderableDBInstanceOption> orderableDBInstanceOptions;
    private final String marker;

    private DescribeOrderableDbInstanceOptionsResponse(BuilderImpl builder) {
        super(builder);
        this.orderableDBInstanceOptions = builder.orderableDBInstanceOptions;
        this.marker = builder.marker;
    }

    public final boolean hasOrderableDBInstanceOptions() {
        return this.orderableDBInstanceOptions != null && !(this.orderableDBInstanceOptions instanceof SdkAutoConstructList);
    }

    public final List<OrderableDBInstanceOption> orderableDBInstanceOptions() {
        return this.orderableDBInstanceOptions;
    }

    public final String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOrderableDBInstanceOptions() ? this.orderableDBInstanceOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableDbInstanceOptionsResponse)) {
            return false;
        }
        DescribeOrderableDbInstanceOptionsResponse other = (DescribeOrderableDbInstanceOptionsResponse)((Object)obj);
        return this.hasOrderableDBInstanceOptions() == other.hasOrderableDBInstanceOptions() && Objects.equals(this.orderableDBInstanceOptions(), other.orderableDBInstanceOptions()) && Objects.equals(this.marker(), other.marker());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeOrderableDbInstanceOptionsResponse").add("OrderableDBInstanceOptions", this.hasOrderableDBInstanceOptions() ? this.orderableDBInstanceOptions() : null).add("Marker", (Object)this.marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderableDBInstanceOptions": {
                return Optional.ofNullable(clazz.cast(this.orderableDBInstanceOptions()));
            }
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("OrderableDBInstanceOptions", ORDERABLE_DB_INSTANCE_OPTIONS_FIELD);
        map.put("Marker", MARKER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeOrderableDbInstanceOptionsResponse, T> g) {
        return obj -> g.apply((DescribeOrderableDbInstanceOptionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DocDbResponse.BuilderImpl
    implements Builder {
        private List<OrderableDBInstanceOption> orderableDBInstanceOptions = DefaultSdkAutoConstructList.getInstance();
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableDbInstanceOptionsResponse model) {
            super(model);
            this.orderableDBInstanceOptions(model.orderableDBInstanceOptions);
            this.marker(model.marker);
        }

        public final List<OrderableDBInstanceOption.Builder> getOrderableDBInstanceOptions() {
            List<OrderableDBInstanceOption.Builder> result = OrderableDBInstanceOptionsListCopier.copyToBuilder(this.orderableDBInstanceOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOrderableDBInstanceOptions(Collection<OrderableDBInstanceOption.BuilderImpl> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copyFromBuilder(orderableDBInstanceOptions);
        }

        @Override
        public final Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions = OrderableDBInstanceOptionsListCopier.copy(orderableDBInstanceOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(OrderableDBInstanceOption ... orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions(Arrays.asList(orderableDBInstanceOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder orderableDBInstanceOptions(Consumer<OrderableDBInstanceOption.Builder> ... orderableDBInstanceOptions) {
            this.orderableDBInstanceOptions(Stream.of(orderableDBInstanceOptions).map(c -> (OrderableDBInstanceOption)((OrderableDBInstanceOption.Builder)OrderableDBInstanceOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        @Override
        public DescribeOrderableDbInstanceOptionsResponse build() {
            return new DescribeOrderableDbInstanceOptionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DocDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeOrderableDbInstanceOptionsResponse> {
        public Builder orderableDBInstanceOptions(Collection<OrderableDBInstanceOption> var1);

        public Builder orderableDBInstanceOptions(OrderableDBInstanceOption ... var1);

        public Builder orderableDBInstanceOptions(Consumer<OrderableDBInstanceOption.Builder> ... var1);

        public Builder marker(String var1);
    }
}

