/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.DlmRequest;
import software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues;
import software.amazon.awssdk.services.dlm.model.PolicyIdListCopier;
import software.amazon.awssdk.services.dlm.model.ResourceTypeValues;
import software.amazon.awssdk.services.dlm.model.ResourceTypeValuesListCopier;
import software.amazon.awssdk.services.dlm.model.TagsToAddFilterListCopier;
import software.amazon.awssdk.services.dlm.model.TargetTagsFilterListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLifecyclePoliciesRequest
extends DlmRequest
implements ToCopyableBuilder<Builder, GetLifecyclePoliciesRequest> {
    private static final SdkField<List<String>> POLICY_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::policyIds)).setter(GetLifecyclePoliciesRequest.setter(Builder::policyIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("policyIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::stateAsString)).setter(GetLifecyclePoliciesRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("state").build()}).build();
    private static final SdkField<List<String>> RESOURCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::resourceTypesAsStrings)).setter(GetLifecyclePoliciesRequest.setter(Builder::resourceTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("resourceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TARGET_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::targetTags)).setter(GetLifecyclePoliciesRequest.setter(Builder::targetTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("targetTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> TAGS_TO_ADD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLifecyclePoliciesRequest.getter(GetLifecyclePoliciesRequest::tagsToAdd)).setter(GetLifecyclePoliciesRequest.setter(Builder::tagsToAdd)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("tagsToAdd").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_IDS_FIELD, STATE_FIELD, RESOURCE_TYPES_FIELD, TARGET_TAGS_FIELD, TAGS_TO_ADD_FIELD));
    private final List<String> policyIds;
    private final String state;
    private final List<String> resourceTypes;
    private final List<String> targetTags;
    private final List<String> tagsToAdd;

    private GetLifecyclePoliciesRequest(BuilderImpl builder) {
        super(builder);
        this.policyIds = builder.policyIds;
        this.state = builder.state;
        this.resourceTypes = builder.resourceTypes;
        this.targetTags = builder.targetTags;
        this.tagsToAdd = builder.tagsToAdd;
    }

    public List<String> policyIds() {
        return this.policyIds;
    }

    public GettablePolicyStateValues state() {
        return GettablePolicyStateValues.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public List<ResourceTypeValues> resourceTypes() {
        return ResourceTypeValuesListCopier.copyStringToEnum(this.resourceTypes);
    }

    public List<String> resourceTypesAsStrings() {
        return this.resourceTypes;
    }

    public List<String> targetTags() {
        return this.targetTags;
    }

    public List<String> tagsToAdd() {
        return this.tagsToAdd;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policyIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypesAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.tagsToAdd());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePoliciesRequest)) {
            return false;
        }
        GetLifecyclePoliciesRequest other = (GetLifecyclePoliciesRequest)((Object)obj);
        return Objects.equals(this.policyIds(), other.policyIds()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.resourceTypesAsStrings(), other.resourceTypesAsStrings()) && Objects.equals(this.targetTags(), other.targetTags()) && Objects.equals(this.tagsToAdd(), other.tagsToAdd());
    }

    public String toString() {
        return ToString.builder((String)"GetLifecyclePoliciesRequest").add("PolicyIds", this.policyIds()).add("State", (Object)this.stateAsString()).add("ResourceTypes", this.resourceTypesAsStrings()).add("TargetTags", this.targetTags()).add("TagsToAdd", this.tagsToAdd()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "PolicyIds": {
                return Optional.ofNullable(clazz.cast(this.policyIds()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "ResourceTypes": {
                return Optional.ofNullable(clazz.cast(this.resourceTypesAsStrings()));
            }
            case "TargetTags": {
                return Optional.ofNullable(clazz.cast(this.targetTags()));
            }
            case "TagsToAdd": {
                return Optional.ofNullable(clazz.cast(this.tagsToAdd()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePoliciesRequest, T> g) {
        return obj -> g.apply((GetLifecyclePoliciesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmRequest.BuilderImpl
    implements Builder {
        private List<String> policyIds = DefaultSdkAutoConstructList.getInstance();
        private String state;
        private List<String> resourceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> targetTags = DefaultSdkAutoConstructList.getInstance();
        private List<String> tagsToAdd = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePoliciesRequest model) {
            super(model);
            this.policyIds(model.policyIds);
            this.state(model.state);
            this.resourceTypesWithStrings(model.resourceTypes);
            this.targetTags(model.targetTags);
            this.tagsToAdd(model.tagsToAdd);
        }

        public final Collection<String> getPolicyIds() {
            return this.policyIds;
        }

        @Override
        public final Builder policyIds(Collection<String> policyIds) {
            this.policyIds = PolicyIdListCopier.copy(policyIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder policyIds(String ... policyIds) {
            this.policyIds(Arrays.asList(policyIds));
            return this;
        }

        public final void setPolicyIds(Collection<String> policyIds) {
            this.policyIds = PolicyIdListCopier.copy(policyIds);
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(GettablePolicyStateValues state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<String> getResourceTypesAsStrings() {
            return this.resourceTypes;
        }

        @Override
        public final Builder resourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypesWithStrings(String ... resourceTypes) {
            this.resourceTypesWithStrings(Arrays.asList(resourceTypes));
            return this;
        }

        @Override
        public final Builder resourceTypes(Collection<ResourceTypeValues> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copyEnumToString(resourceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTypes(ResourceTypeValues ... resourceTypes) {
            this.resourceTypes(Arrays.asList(resourceTypes));
            return this;
        }

        public final void setResourceTypesWithStrings(Collection<String> resourceTypes) {
            this.resourceTypes = ResourceTypeValuesListCopier.copy(resourceTypes);
        }

        public final Collection<String> getTargetTags() {
            return this.targetTags;
        }

        @Override
        public final Builder targetTags(Collection<String> targetTags) {
            this.targetTags = TargetTagsFilterListCopier.copy(targetTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder targetTags(String ... targetTags) {
            this.targetTags(Arrays.asList(targetTags));
            return this;
        }

        public final void setTargetTags(Collection<String> targetTags) {
            this.targetTags = TargetTagsFilterListCopier.copy(targetTags);
        }

        public final Collection<String> getTagsToAdd() {
            return this.tagsToAdd;
        }

        @Override
        public final Builder tagsToAdd(Collection<String> tagsToAdd) {
            this.tagsToAdd = TagsToAddFilterListCopier.copy(tagsToAdd);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagsToAdd(String ... tagsToAdd) {
            this.tagsToAdd(Arrays.asList(tagsToAdd));
            return this;
        }

        public final void setTagsToAdd(Collection<String> tagsToAdd) {
            this.tagsToAdd = TagsToAddFilterListCopier.copy(tagsToAdd);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLifecyclePoliciesRequest build() {
            return new GetLifecyclePoliciesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DlmRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLifecyclePoliciesRequest> {
        public Builder policyIds(Collection<String> var1);

        public Builder policyIds(String ... var1);

        public Builder state(String var1);

        public Builder state(GettablePolicyStateValues var1);

        public Builder resourceTypesWithStrings(Collection<String> var1);

        public Builder resourceTypesWithStrings(String ... var1);

        public Builder resourceTypes(Collection<ResourceTypeValues> var1);

        public Builder resourceTypes(ResourceTypeValues ... var1);

        public Builder targetTags(Collection<String> var1);

        public Builder targetTags(String ... var1);

        public Builder tagsToAdd(Collection<String> var1);

        public Builder tagsToAdd(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

