/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dlm.model.DlmResponse;
import software.amazon.awssdk.services.dlm.model.LifecyclePolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLifecyclePolicyResponse
extends DlmResponse
implements ToCopyableBuilder<Builder, GetLifecyclePolicyResponse> {
    private static final SdkField<LifecyclePolicy> POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Policy").getter(GetLifecyclePolicyResponse.getter(GetLifecyclePolicyResponse::policy)).setter(GetLifecyclePolicyResponse.setter(Builder::policy)).constructor(LifecyclePolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Policy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POLICY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetLifecyclePolicyResponse.memberNameToFieldInitializer();
    private final LifecyclePolicy policy;

    private GetLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.policy = builder.policy;
    }

    public final LifecyclePolicy policy() {
        return this.policy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.policy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyResponse)) {
            return false;
        }
        GetLifecyclePolicyResponse other = (GetLifecyclePolicyResponse)((Object)obj);
        return Objects.equals(this.policy(), other.policy());
    }

    public final String toString() {
        return ToString.builder((String)"GetLifecyclePolicyResponse").add("Policy", (Object)this.policy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Policy": {
                return Optional.ofNullable(clazz.cast(this.policy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<LifecyclePolicy>> map = new HashMap<String, SdkField<LifecyclePolicy>>();
        map.put("Policy", POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((GetLifecyclePolicyResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmResponse.BuilderImpl
    implements Builder {
        private LifecyclePolicy policy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyResponse model) {
            super(model);
            this.policy(model.policy);
        }

        public final LifecyclePolicy.Builder getPolicy() {
            return this.policy != null ? this.policy.toBuilder() : null;
        }

        public final void setPolicy(LifecyclePolicy.BuilderImpl policy) {
            this.policy = policy != null ? policy.build() : null;
        }

        @Override
        public final Builder policy(LifecyclePolicy policy) {
            this.policy = policy;
            return this;
        }

        @Override
        public GetLifecyclePolicyResponse build() {
            return new GetLifecyclePolicyResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DlmResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLifecyclePolicyResponse> {
        public Builder policy(LifecyclePolicy var1);

        default public Builder policy(Consumer<LifecyclePolicy.Builder> policy) {
            return this.policy((LifecyclePolicy)((LifecyclePolicy.Builder)LifecyclePolicy.builder().applyMutation(policy)).build());
        }
    }
}

