/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.dlm.model.DlmException;
import software.amazon.awssdk.services.dlm.model.ParameterListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvalidRequestException
extends DlmException
implements ToCopyableBuilder<Builder, InvalidRequestException> {
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Code").getter(InvalidRequestException.getter(InvalidRequestException::code)).setter(InvalidRequestException.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()}).build();
    private static final SdkField<List<String>> REQUIRED_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("RequiredParameters").getter(InvalidRequestException.getter(InvalidRequestException::requiredParameters)).setter(InvalidRequestException.setter(Builder::requiredParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequiredParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> MUTUALLY_EXCLUSIVE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MutuallyExclusiveParameters").getter(InvalidRequestException.getter(InvalidRequestException::mutuallyExclusiveParameters)).setter(InvalidRequestException.setter(Builder::mutuallyExclusiveParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MutuallyExclusiveParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, REQUIRED_PARAMETERS_FIELD, MUTUALLY_EXCLUSIVE_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InvalidRequestException.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String code;
    private final List<String> requiredParameters;
    private final List<String> mutuallyExclusiveParameters;

    private InvalidRequestException(BuilderImpl builder) {
        super(builder);
        this.code = builder.code;
        this.requiredParameters = builder.requiredParameters;
        this.mutuallyExclusiveParameters = builder.mutuallyExclusiveParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public String code() {
        return this.code;
    }

    public boolean hasRequiredParameters() {
        return this.requiredParameters != null && !(this.requiredParameters instanceof SdkAutoConstructList);
    }

    public List<String> requiredParameters() {
        return this.requiredParameters;
    }

    public boolean hasMutuallyExclusiveParameters() {
        return this.mutuallyExclusiveParameters != null && !(this.mutuallyExclusiveParameters instanceof SdkAutoConstructList);
    }

    public List<String> mutuallyExclusiveParameters() {
        return this.mutuallyExclusiveParameters;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Code", CODE_FIELD);
        map.put("RequiredParameters", REQUIRED_PARAMETERS_FIELD);
        map.put("MutuallyExclusiveParameters", MUTUALLY_EXCLUSIVE_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InvalidRequestException, T> g) {
        return obj -> g.apply((InvalidRequestException)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DlmException.BuilderImpl
    implements Builder {
        private String code;
        private List<String> requiredParameters = DefaultSdkAutoConstructList.getInstance();
        private List<String> mutuallyExclusiveParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InvalidRequestException model) {
            super(model);
            this.code(model.code);
            this.requiredParameters(model.requiredParameters);
            this.mutuallyExclusiveParameters(model.mutuallyExclusiveParameters);
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final Collection<String> getRequiredParameters() {
            if (this.requiredParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.requiredParameters;
        }

        public final void setRequiredParameters(Collection<String> requiredParameters) {
            this.requiredParameters = ParameterListCopier.copy(requiredParameters);
        }

        @Override
        public final Builder requiredParameters(Collection<String> requiredParameters) {
            this.requiredParameters = ParameterListCopier.copy(requiredParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder requiredParameters(String ... requiredParameters) {
            this.requiredParameters(Arrays.asList(requiredParameters));
            return this;
        }

        public final Collection<String> getMutuallyExclusiveParameters() {
            if (this.mutuallyExclusiveParameters instanceof SdkAutoConstructList) {
                return null;
            }
            return this.mutuallyExclusiveParameters;
        }

        public final void setMutuallyExclusiveParameters(Collection<String> mutuallyExclusiveParameters) {
            this.mutuallyExclusiveParameters = ParameterListCopier.copy(mutuallyExclusiveParameters);
        }

        @Override
        public final Builder mutuallyExclusiveParameters(Collection<String> mutuallyExclusiveParameters) {
            this.mutuallyExclusiveParameters = ParameterListCopier.copy(mutuallyExclusiveParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mutuallyExclusiveParameters(String ... mutuallyExclusiveParameters) {
            this.mutuallyExclusiveParameters(Arrays.asList(mutuallyExclusiveParameters));
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public InvalidRequestException build() {
            return new InvalidRequestException(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvalidRequestException>,
    DlmException.Builder {
        public Builder code(String var1);

        public Builder requiredParameters(Collection<String> var1);

        public Builder requiredParameters(String ... var1);

        public Builder mutuallyExclusiveParameters(Collection<String> var1);

        public Builder mutuallyExclusiveParameters(String ... var1);

        @Override
        public Builder awsErrorDetails(AwsErrorDetails var1);

        @Override
        public Builder message(String var1);

        @Override
        public Builder requestId(String var1);

        @Override
        public Builder statusCode(int var1);

        @Override
        public Builder cause(Throwable var1);

        @Override
        public Builder writableStackTrace(Boolean var1);

        @Override
        public Builder numAttempts(Integer var1);
    }
}

