/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dlm.DefaultDlmAsyncClient;
import software.amazon.awssdk.services.dlm.DefaultDlmBaseClientBuilder;
import software.amazon.awssdk.services.dlm.DlmAsyncClient;
import software.amazon.awssdk.services.dlm.DlmAsyncClientBuilder;
import software.amazon.awssdk.services.dlm.DlmServiceClientConfiguration;
import software.amazon.awssdk.services.dlm.endpoints.DlmEndpointProvider;

@SdkInternalApi
final class DefaultDlmAsyncClientBuilder
extends DefaultDlmBaseClientBuilder<DlmAsyncClientBuilder, DlmAsyncClient>
implements DlmAsyncClientBuilder {
    DefaultDlmAsyncClientBuilder() {
    }

    @Override
    public DefaultDlmAsyncClientBuilder endpointProvider(DlmEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final DlmAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultDlmAsyncClientBuilder.validateClientOptions(clientConfiguration);
        DlmServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultDlmAsyncClient client = new DefaultDlmAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private DlmServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return DlmServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

