/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PolicyTypeValues {
    EBS_SNAPSHOT_MANAGEMENT("EBS_SNAPSHOT_MANAGEMENT"),
    IMAGE_MANAGEMENT("IMAGE_MANAGEMENT"),
    EVENT_BASED_POLICY("EVENT_BASED_POLICY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PolicyTypeValues> VALUE_MAP;
    private final String value;

    private PolicyTypeValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PolicyTypeValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PolicyTypeValues> knownValues() {
        EnumSet<PolicyTypeValues> knownValues = EnumSet.allOf(PolicyTypeValues.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PolicyTypeValues.class, PolicyTypeValues::toString);
    }
}

