/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyDeprecateRule;
import software.amazon.awssdk.services.dlm.model.CrossRegionCopyRetainRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CrossRegionCopyRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CrossRegionCopyRule> {
    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetRegion").getter(CrossRegionCopyRule.getter(CrossRegionCopyRule::targetRegion)).setter(CrossRegionCopyRule.setter(Builder::targetRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetRegion").build()}).build();
    private static final SdkField<String> TARGET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Target").getter(CrossRegionCopyRule.getter(CrossRegionCopyRule::target)).setter(CrossRegionCopyRule.setter(Builder::target)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Target").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(CrossRegionCopyRule.getter(CrossRegionCopyRule::encrypted)).setter(CrossRegionCopyRule.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<String> CMK_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CmkArn").getter(CrossRegionCopyRule.getter(CrossRegionCopyRule::cmkArn)).setter(CrossRegionCopyRule.setter(Builder::cmkArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CmkArn").build()}).build();
    private static final SdkField<Boolean> COPY_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CopyTags").getter(CrossRegionCopyRule.getter(CrossRegionCopyRule::copyTags)).setter(CrossRegionCopyRule.setter(Builder::copyTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CopyTags").build()}).build();
    private static final SdkField<CrossRegionCopyRetainRule> RETAIN_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetainRule").getter(CrossRegionCopyRule.getter(CrossRegionCopyRule::retainRule)).setter(CrossRegionCopyRule.setter(Builder::retainRule)).constructor(CrossRegionCopyRetainRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetainRule").build()}).build();
    private static final SdkField<CrossRegionCopyDeprecateRule> DEPRECATE_RULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DeprecateRule").getter(CrossRegionCopyRule.getter(CrossRegionCopyRule::deprecateRule)).setter(CrossRegionCopyRule.setter(Builder::deprecateRule)).constructor(CrossRegionCopyDeprecateRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeprecateRule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_REGION_FIELD, TARGET_FIELD, ENCRYPTED_FIELD, CMK_ARN_FIELD, COPY_TAGS_FIELD, RETAIN_RULE_FIELD, DEPRECATE_RULE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String targetRegion;
    private final String target;
    private final Boolean encrypted;
    private final String cmkArn;
    private final Boolean copyTags;
    private final CrossRegionCopyRetainRule retainRule;
    private final CrossRegionCopyDeprecateRule deprecateRule;

    private CrossRegionCopyRule(BuilderImpl builder) {
        this.targetRegion = builder.targetRegion;
        this.target = builder.target;
        this.encrypted = builder.encrypted;
        this.cmkArn = builder.cmkArn;
        this.copyTags = builder.copyTags;
        this.retainRule = builder.retainRule;
        this.deprecateRule = builder.deprecateRule;
    }

    public final String targetRegion() {
        return this.targetRegion;
    }

    public final String target() {
        return this.target;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final String cmkArn() {
        return this.cmkArn;
    }

    public final Boolean copyTags() {
        return this.copyTags;
    }

    public final CrossRegionCopyRetainRule retainRule() {
        return this.retainRule;
    }

    public final CrossRegionCopyDeprecateRule deprecateRule() {
        return this.deprecateRule;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.target());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.cmkArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.copyTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.retainRule());
        hashCode = 31 * hashCode + Objects.hashCode(this.deprecateRule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CrossRegionCopyRule)) {
            return false;
        }
        CrossRegionCopyRule other = (CrossRegionCopyRule)obj;
        return Objects.equals(this.targetRegion(), other.targetRegion()) && Objects.equals(this.target(), other.target()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.cmkArn(), other.cmkArn()) && Objects.equals(this.copyTags(), other.copyTags()) && Objects.equals(this.retainRule(), other.retainRule()) && Objects.equals(this.deprecateRule(), other.deprecateRule());
    }

    public final String toString() {
        return ToString.builder((String)"CrossRegionCopyRule").add("TargetRegion", (Object)this.targetRegion()).add("Target", (Object)this.target()).add("Encrypted", (Object)this.encrypted()).add("CmkArn", (Object)this.cmkArn()).add("CopyTags", (Object)this.copyTags()).add("RetainRule", (Object)this.retainRule()).add("DeprecateRule", (Object)this.deprecateRule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetRegion": {
                return Optional.ofNullable(clazz.cast(this.targetRegion()));
            }
            case "Target": {
                return Optional.ofNullable(clazz.cast(this.target()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "CmkArn": {
                return Optional.ofNullable(clazz.cast(this.cmkArn()));
            }
            case "CopyTags": {
                return Optional.ofNullable(clazz.cast(this.copyTags()));
            }
            case "RetainRule": {
                return Optional.ofNullable(clazz.cast(this.retainRule()));
            }
            case "DeprecateRule": {
                return Optional.ofNullable(clazz.cast(this.deprecateRule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CrossRegionCopyRule, T> g) {
        return obj -> g.apply((CrossRegionCopyRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetRegion;
        private String target;
        private Boolean encrypted;
        private String cmkArn;
        private Boolean copyTags;
        private CrossRegionCopyRetainRule retainRule;
        private CrossRegionCopyDeprecateRule deprecateRule;

        private BuilderImpl() {
        }

        private BuilderImpl(CrossRegionCopyRule model) {
            this.targetRegion(model.targetRegion);
            this.target(model.target);
            this.encrypted(model.encrypted);
            this.cmkArn(model.cmkArn);
            this.copyTags(model.copyTags);
            this.retainRule(model.retainRule);
            this.deprecateRule(model.deprecateRule);
        }

        public final String getTargetRegion() {
            return this.targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        @Transient
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(String target) {
            this.target = target;
        }

        @Override
        @Transient
        public final Builder target(String target) {
            this.target = target;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final String getCmkArn() {
            return this.cmkArn;
        }

        public final void setCmkArn(String cmkArn) {
            this.cmkArn = cmkArn;
        }

        @Override
        @Transient
        public final Builder cmkArn(String cmkArn) {
            this.cmkArn = cmkArn;
            return this;
        }

        public final Boolean getCopyTags() {
            return this.copyTags;
        }

        public final void setCopyTags(Boolean copyTags) {
            this.copyTags = copyTags;
        }

        @Override
        @Transient
        public final Builder copyTags(Boolean copyTags) {
            this.copyTags = copyTags;
            return this;
        }

        public final CrossRegionCopyRetainRule.Builder getRetainRule() {
            return this.retainRule != null ? this.retainRule.toBuilder() : null;
        }

        public final void setRetainRule(CrossRegionCopyRetainRule.BuilderImpl retainRule) {
            this.retainRule = retainRule != null ? retainRule.build() : null;
        }

        @Override
        @Transient
        public final Builder retainRule(CrossRegionCopyRetainRule retainRule) {
            this.retainRule = retainRule;
            return this;
        }

        public final CrossRegionCopyDeprecateRule.Builder getDeprecateRule() {
            return this.deprecateRule != null ? this.deprecateRule.toBuilder() : null;
        }

        public final void setDeprecateRule(CrossRegionCopyDeprecateRule.BuilderImpl deprecateRule) {
            this.deprecateRule = deprecateRule != null ? deprecateRule.build() : null;
        }

        @Override
        @Transient
        public final Builder deprecateRule(CrossRegionCopyDeprecateRule deprecateRule) {
            this.deprecateRule = deprecateRule;
            return this;
        }

        public CrossRegionCopyRule build() {
            return new CrossRegionCopyRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CrossRegionCopyRule> {
        public Builder targetRegion(String var1);

        public Builder target(String var1);

        public Builder encrypted(Boolean var1);

        public Builder cmkArn(String var1);

        public Builder copyTags(Boolean var1);

        public Builder retainRule(CrossRegionCopyRetainRule var1);

        default public Builder retainRule(Consumer<CrossRegionCopyRetainRule.Builder> retainRule) {
            return this.retainRule((CrossRegionCopyRetainRule)((CrossRegionCopyRetainRule.Builder)CrossRegionCopyRetainRule.builder().applyMutation(retainRule)).build());
        }

        public Builder deprecateRule(CrossRegionCopyDeprecateRule var1);

        default public Builder deprecateRule(Consumer<CrossRegionCopyDeprecateRule.Builder> deprecateRule) {
            return this.deprecateRule((CrossRegionCopyDeprecateRule)((CrossRegionCopyDeprecateRule.Builder)CrossRegionCopyDeprecateRule.builder().applyMutation(deprecateRule)).build());
        }
    }
}

