/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dlm.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventTypeValues {
    SHARE_SNAPSHOT("shareSnapshot"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventTypeValues(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventTypeValues fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventTypeValues.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventTypeValues> knownValues() {
        return Stream.of(EventTypeValues.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

