/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directoryservicedata.DirectoryServiceDataAsyncClient;
import software.amazon.awssdk.services.directoryservicedata.internal.UserAgentUtils;
import software.amazon.awssdk.services.directoryservicedata.model.GroupSummary;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberRequest;
import software.amazon.awssdk.services.directoryservicedata.model.ListGroupsForMemberResponse;

public class ListGroupsForMemberPublisher
implements SdkPublisher<ListGroupsForMemberResponse> {
    private final DirectoryServiceDataAsyncClient client;
    private final ListGroupsForMemberRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListGroupsForMemberPublisher(DirectoryServiceDataAsyncClient client, ListGroupsForMemberRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListGroupsForMemberPublisher(DirectoryServiceDataAsyncClient client, ListGroupsForMemberRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListGroupsForMemberResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListGroupsForMemberResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<GroupSummary> groups() {
        Function<ListGroupsForMemberResponse, Iterator> getIterator = response -> {
            if (response != null && response.groups() != null) {
                return response.groups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListGroupsForMemberResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListGroupsForMemberResponseFetcher
    implements AsyncPageFetcher<ListGroupsForMemberResponse> {
        private ListGroupsForMemberResponseFetcher() {
        }

        public boolean hasNextPage(ListGroupsForMemberResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListGroupsForMemberResponse> nextPage(ListGroupsForMemberResponse previousPage) {
            if (previousPage == null) {
                return ListGroupsForMemberPublisher.this.client.listGroupsForMember(ListGroupsForMemberPublisher.this.firstRequest);
            }
            return ListGroupsForMemberPublisher.this.client.listGroupsForMember((ListGroupsForMemberRequest)((Object)ListGroupsForMemberPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

