/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddGroupMemberRequest
extends DirectoryServiceDataRequest
implements ToCopyableBuilder<Builder, AddGroupMemberRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(AddGroupMemberRequest.getter(AddGroupMemberRequest::clientToken)).setter(AddGroupMemberRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(AddGroupMemberRequest.getter(AddGroupMemberRequest::directoryId)).setter(AddGroupMemberRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupName").getter(AddGroupMemberRequest.getter(AddGroupMemberRequest::groupName)).setter(AddGroupMemberRequest.setter(Builder::groupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupName").build()}).build();
    private static final SdkField<String> MEMBER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberName").getter(AddGroupMemberRequest.getter(AddGroupMemberRequest::memberName)).setter(AddGroupMemberRequest.setter(Builder::memberName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberName").build()}).build();
    private static final SdkField<String> MEMBER_REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberRealm").getter(AddGroupMemberRequest.getter(AddGroupMemberRequest::memberRealm)).setter(AddGroupMemberRequest.setter(Builder::memberRealm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberRealm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DIRECTORY_ID_FIELD, GROUP_NAME_FIELD, MEMBER_NAME_FIELD, MEMBER_REALM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("GroupName", GROUP_NAME_FIELD);
            this.put("MemberName", MEMBER_NAME_FIELD);
            this.put("MemberRealm", MEMBER_REALM_FIELD);
        }
    });
    private final String clientToken;
    private final String directoryId;
    private final String groupName;
    private final String memberName;
    private final String memberRealm;

    private AddGroupMemberRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.directoryId = builder.directoryId;
        this.groupName = builder.groupName;
        this.memberName = builder.memberName;
        this.memberRealm = builder.memberRealm;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String groupName() {
        return this.groupName;
    }

    public final String memberName() {
        return this.memberName;
    }

    public final String memberRealm() {
        return this.memberRealm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberName());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberRealm());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddGroupMemberRequest)) {
            return false;
        }
        AddGroupMemberRequest other = (AddGroupMemberRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.groupName(), other.groupName()) && Objects.equals(this.memberName(), other.memberName()) && Objects.equals(this.memberRealm(), other.memberRealm());
    }

    public final String toString() {
        return ToString.builder((String)"AddGroupMemberRequest").add("ClientToken", (Object)this.clientToken()).add("DirectoryId", (Object)this.directoryId()).add("GroupName", (Object)this.groupName()).add("MemberName", (Object)this.memberName()).add("MemberRealm", (Object)this.memberRealm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "GroupName": {
                return Optional.ofNullable(clazz.cast(this.groupName()));
            }
            case "MemberName": {
                return Optional.ofNullable(clazz.cast(this.memberName()));
            }
            case "MemberRealm": {
                return Optional.ofNullable(clazz.cast(this.memberRealm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddGroupMemberRequest, T> g) {
        return obj -> g.apply((AddGroupMemberRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryServiceDataRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String directoryId;
        private String groupName;
        private String memberName;
        private String memberRealm;

        private BuilderImpl() {
        }

        private BuilderImpl(AddGroupMemberRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.directoryId(model.directoryId);
            this.groupName(model.groupName);
            this.memberName(model.memberName);
            this.memberRealm(model.memberRealm);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getGroupName() {
            return this.groupName;
        }

        public final void setGroupName(String groupName) {
            this.groupName = groupName;
        }

        @Override
        public final Builder groupName(String groupName) {
            this.groupName = groupName;
            return this;
        }

        public final String getMemberName() {
            return this.memberName;
        }

        public final void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        @Override
        public final Builder memberName(String memberName) {
            this.memberName = memberName;
            return this;
        }

        public final String getMemberRealm() {
            return this.memberRealm;
        }

        public final void setMemberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
        }

        @Override
        public final Builder memberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddGroupMemberRequest build() {
            return new AddGroupMemberRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryServiceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddGroupMemberRequest> {
        public Builder clientToken(String var1);

        public Builder directoryId(String var1);

        public Builder groupName(String var1);

        public Builder memberName(String var1);

        public Builder memberRealm(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

