/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.directoryservicedata.model.AttributeValue;
import software.amazon.awssdk.services.directoryservicedata.model.AttributesCopier;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataRequest;
import software.amazon.awssdk.services.directoryservicedata.model.GroupScope;
import software.amazon.awssdk.services.directoryservicedata.model.GroupType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateGroupRequest
extends DirectoryServiceDataRequest
implements ToCopyableBuilder<Builder, CreateGroupRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateGroupRequest.getter(CreateGroupRequest::clientToken)).setter(CreateGroupRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(CreateGroupRequest.getter(CreateGroupRequest::directoryId)).setter(CreateGroupRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> GROUP_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupScope").getter(CreateGroupRequest.getter(CreateGroupRequest::groupScopeAsString)).setter(CreateGroupRequest.setter(Builder::groupScope)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupScope").build()}).build();
    private static final SdkField<String> GROUP_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GroupType").getter(CreateGroupRequest.getter(CreateGroupRequest::groupTypeAsString)).setter(CreateGroupRequest.setter(Builder::groupType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GroupType").build()}).build();
    private static final SdkField<Map<String, AttributeValue>> OTHER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("OtherAttributes").getter(CreateGroupRequest.getter(CreateGroupRequest::otherAttributes)).setter(CreateGroupRequest.setter(Builder::otherAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AttributeValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMAccountName").getter(CreateGroupRequest.getter(CreateGroupRequest::samAccountName)).setter(CreateGroupRequest.setter(Builder::samAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DIRECTORY_ID_FIELD, GROUP_SCOPE_FIELD, GROUP_TYPE_FIELD, OTHER_ATTRIBUTES_FIELD, SAM_ACCOUNT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClientToken", CLIENT_TOKEN_FIELD);
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("GroupScope", GROUP_SCOPE_FIELD);
            this.put("GroupType", GROUP_TYPE_FIELD);
            this.put("OtherAttributes", OTHER_ATTRIBUTES_FIELD);
            this.put("SAMAccountName", SAM_ACCOUNT_NAME_FIELD);
        }
    });
    private final String clientToken;
    private final String directoryId;
    private final String groupScope;
    private final String groupType;
    private final Map<String, AttributeValue> otherAttributes;
    private final String samAccountName;

    private CreateGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.directoryId = builder.directoryId;
        this.groupScope = builder.groupScope;
        this.groupType = builder.groupType;
        this.otherAttributes = builder.otherAttributes;
        this.samAccountName = builder.samAccountName;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final GroupScope groupScope() {
        return GroupScope.fromValue(this.groupScope);
    }

    public final String groupScopeAsString() {
        return this.groupScope;
    }

    public final GroupType groupType() {
        return GroupType.fromValue(this.groupType);
    }

    public final String groupTypeAsString() {
        return this.groupType;
    }

    public final boolean hasOtherAttributes() {
        return this.otherAttributes != null && !(this.otherAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, AttributeValue> otherAttributes() {
        return this.otherAttributes;
    }

    public final String samAccountName() {
        return this.samAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.groupTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtherAttributes() ? this.otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.samAccountName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateGroupRequest)) {
            return false;
        }
        CreateGroupRequest other = (CreateGroupRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.groupScopeAsString(), other.groupScopeAsString()) && Objects.equals(this.groupTypeAsString(), other.groupTypeAsString()) && this.hasOtherAttributes() == other.hasOtherAttributes() && Objects.equals(this.otherAttributes(), other.otherAttributes()) && Objects.equals(this.samAccountName(), other.samAccountName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateGroupRequest").add("ClientToken", (Object)this.clientToken()).add("DirectoryId", (Object)this.directoryId()).add("GroupScope", (Object)this.groupScopeAsString()).add("GroupType", (Object)this.groupTypeAsString()).add("OtherAttributes", this.hasOtherAttributes() ? this.otherAttributes() : null).add("SAMAccountName", (Object)this.samAccountName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "GroupScope": {
                return Optional.ofNullable(clazz.cast(this.groupScopeAsString()));
            }
            case "GroupType": {
                return Optional.ofNullable(clazz.cast(this.groupTypeAsString()));
            }
            case "OtherAttributes": {
                return Optional.ofNullable(clazz.cast(this.otherAttributes()));
            }
            case "SAMAccountName": {
                return Optional.ofNullable(clazz.cast(this.samAccountName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateGroupRequest, T> g) {
        return obj -> g.apply((CreateGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryServiceDataRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String directoryId;
        private String groupScope;
        private String groupType;
        private Map<String, AttributeValue> otherAttributes = DefaultSdkAutoConstructMap.getInstance();
        private String samAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateGroupRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.directoryId(model.directoryId);
            this.groupScope(model.groupScope);
            this.groupType(model.groupType);
            this.otherAttributes(model.otherAttributes);
            this.samAccountName(model.samAccountName);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getGroupScope() {
            return this.groupScope;
        }

        public final void setGroupScope(String groupScope) {
            this.groupScope = groupScope;
        }

        @Override
        public final Builder groupScope(String groupScope) {
            this.groupScope = groupScope;
            return this;
        }

        @Override
        public final Builder groupScope(GroupScope groupScope) {
            this.groupScope(groupScope == null ? null : groupScope.toString());
            return this;
        }

        public final String getGroupType() {
            return this.groupType;
        }

        public final void setGroupType(String groupType) {
            this.groupType = groupType;
        }

        @Override
        public final Builder groupType(String groupType) {
            this.groupType = groupType;
            return this;
        }

        @Override
        public final Builder groupType(GroupType groupType) {
            this.groupType(groupType == null ? null : groupType.toString());
            return this;
        }

        public final Map<String, AttributeValue.Builder> getOtherAttributes() {
            Map<String, AttributeValue.Builder> result = AttributesCopier.copyToBuilder(this.otherAttributes);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setOtherAttributes(Map<String, AttributeValue.BuilderImpl> otherAttributes) {
            this.otherAttributes = AttributesCopier.copyFromBuilder(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Map<String, AttributeValue> otherAttributes) {
            this.otherAttributes = AttributesCopier.copy(otherAttributes);
            return this;
        }

        public final String getSamAccountName() {
            return this.samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateGroupRequest build() {
            return new CreateGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryServiceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateGroupRequest> {
        public Builder clientToken(String var1);

        public Builder directoryId(String var1);

        public Builder groupScope(String var1);

        public Builder groupScope(GroupScope var1);

        public Builder groupType(String var1);

        public Builder groupType(GroupType var1);

        public Builder otherAttributes(Map<String, AttributeValue> var1);

        public Builder samAccountName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

