/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataResponse;
import software.amazon.awssdk.services.directoryservicedata.model.Member;
import software.amazon.awssdk.services.directoryservicedata.model.MemberListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGroupMembersResponse
extends DirectoryServiceDataResponse
implements ToCopyableBuilder<Builder, ListGroupMembersResponse> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(ListGroupMembersResponse.getter(ListGroupMembersResponse::directoryId)).setter(ListGroupMembersResponse.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> MEMBER_REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MemberRealm").getter(ListGroupMembersResponse.getter(ListGroupMembersResponse::memberRealm)).setter(ListGroupMembersResponse.setter(Builder::memberRealm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberRealm").build()}).build();
    private static final SdkField<List<Member>> MEMBERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Members").getter(ListGroupMembersResponse.getter(ListGroupMembersResponse::members)).setter(ListGroupMembersResponse.setter(Builder::members)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Member::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListGroupMembersResponse.getter(ListGroupMembersResponse::nextToken)).setter(ListGroupMembersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<String> REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Realm").getter(ListGroupMembersResponse.getter(ListGroupMembersResponse::realm)).setter(ListGroupMembersResponse.setter(Builder::realm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, MEMBER_REALM_FIELD, MEMBERS_FIELD, NEXT_TOKEN_FIELD, REALM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("DirectoryId", DIRECTORY_ID_FIELD);
            this.put("MemberRealm", MEMBER_REALM_FIELD);
            this.put("Members", MEMBERS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
            this.put("Realm", REALM_FIELD);
        }
    });
    private final String directoryId;
    private final String memberRealm;
    private final List<Member> members;
    private final String nextToken;
    private final String realm;

    private ListGroupMembersResponse(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.memberRealm = builder.memberRealm;
        this.members = builder.members;
        this.nextToken = builder.nextToken;
        this.realm = builder.realm;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String memberRealm() {
        return this.memberRealm;
    }

    public final boolean hasMembers() {
        return this.members != null && !(this.members instanceof SdkAutoConstructList);
    }

    public final List<Member> members() {
        return this.members;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String realm() {
        return this.realm;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberRealm());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMembers() ? this.members() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGroupMembersResponse)) {
            return false;
        }
        ListGroupMembersResponse other = (ListGroupMembersResponse)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.memberRealm(), other.memberRealm()) && this.hasMembers() == other.hasMembers() && Objects.equals(this.members(), other.members()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.realm(), other.realm());
    }

    public final String toString() {
        return ToString.builder((String)"ListGroupMembersResponse").add("DirectoryId", (Object)this.directoryId()).add("MemberRealm", (Object)this.memberRealm()).add("Members", this.hasMembers() ? this.members() : null).add("NextToken", (Object)(this.nextToken() == null ? null : "*** Sensitive Data Redacted ***")).add("Realm", (Object)this.realm()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "MemberRealm": {
                return Optional.ofNullable(clazz.cast(this.memberRealm()));
            }
            case "Members": {
                return Optional.ofNullable(clazz.cast(this.members()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListGroupMembersResponse, T> g) {
        return obj -> g.apply((ListGroupMembersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryServiceDataResponse.BuilderImpl
    implements Builder {
        private String directoryId;
        private String memberRealm;
        private List<Member> members = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;
        private String realm;

        private BuilderImpl() {
        }

        private BuilderImpl(ListGroupMembersResponse model) {
            super(model);
            this.directoryId(model.directoryId);
            this.memberRealm(model.memberRealm);
            this.members(model.members);
            this.nextToken(model.nextToken);
            this.realm(model.realm);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getMemberRealm() {
            return this.memberRealm;
        }

        public final void setMemberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
        }

        @Override
        public final Builder memberRealm(String memberRealm) {
            this.memberRealm = memberRealm;
            return this;
        }

        public final List<Member.Builder> getMembers() {
            List<Member.Builder> result = MemberListCopier.copyToBuilder(this.members);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMembers(Collection<Member.BuilderImpl> members) {
            this.members = MemberListCopier.copyFromBuilder(members);
        }

        @Override
        public final Builder members(Collection<Member> members) {
            this.members = MemberListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Member ... members) {
            this.members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<Member.Builder> ... members) {
            this.members(Stream.of(members).map(c -> (Member)((Member.Builder)Member.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        @Override
        public ListGroupMembersResponse build() {
            return new ListGroupMembersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryServiceDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGroupMembersResponse> {
        public Builder directoryId(String var1);

        public Builder memberRealm(String var1);

        public Builder members(Collection<Member> var1);

        public Builder members(Member ... var1);

        public Builder members(Consumer<Member.Builder> ... var1);

        public Builder nextToken(String var1);

        public Builder realm(String var1);
    }
}

