/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directoryservicedata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directoryservicedata.model.DirectoryServiceDataRequest;
import software.amazon.awssdk.services.directoryservicedata.model.LdapDisplayNameListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeGroupRequest
extends DirectoryServiceDataRequest
implements ToCopyableBuilder<Builder, DescribeGroupRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DescribeGroupRequest.getter(DescribeGroupRequest::directoryId)).setter(DescribeGroupRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("DirectoryId").build()}).build();
    private static final SdkField<List<String>> OTHER_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OtherAttributes").getter(DescribeGroupRequest.getter(DescribeGroupRequest::otherAttributes)).setter(DescribeGroupRequest.setter(Builder::otherAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REALM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Realm").getter(DescribeGroupRequest.getter(DescribeGroupRequest::realm)).setter(DescribeGroupRequest.setter(Builder::realm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()}).build();
    private static final SdkField<String> SAM_ACCOUNT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SAMAccountName").getter(DescribeGroupRequest.getter(DescribeGroupRequest::samAccountName)).setter(DescribeGroupRequest.setter(Builder::samAccountName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SAMAccountName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, OTHER_ATTRIBUTES_FIELD, REALM_FIELD, SAM_ACCOUNT_NAME_FIELD));
    private final String directoryId;
    private final List<String> otherAttributes;
    private final String realm;
    private final String samAccountName;

    private DescribeGroupRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.otherAttributes = builder.otherAttributes;
        this.realm = builder.realm;
        this.samAccountName = builder.samAccountName;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final boolean hasOtherAttributes() {
        return this.otherAttributes != null && !(this.otherAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> otherAttributes() {
        return this.otherAttributes;
    }

    public final String realm() {
        return this.realm;
    }

    public final String samAccountName() {
        return this.samAccountName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtherAttributes() ? this.otherAttributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.realm());
        hashCode = 31 * hashCode + Objects.hashCode(this.samAccountName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeGroupRequest)) {
            return false;
        }
        DescribeGroupRequest other = (DescribeGroupRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && this.hasOtherAttributes() == other.hasOtherAttributes() && Objects.equals(this.otherAttributes(), other.otherAttributes()) && Objects.equals(this.realm(), other.realm()) && Objects.equals(this.samAccountName(), other.samAccountName());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeGroupRequest").add("DirectoryId", (Object)this.directoryId()).add("OtherAttributes", this.hasOtherAttributes() ? this.otherAttributes() : null).add("Realm", (Object)this.realm()).add("SAMAccountName", (Object)this.samAccountName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "OtherAttributes": {
                return Optional.ofNullable(clazz.cast(this.otherAttributes()));
            }
            case "Realm": {
                return Optional.ofNullable(clazz.cast(this.realm()));
            }
            case "SAMAccountName": {
                return Optional.ofNullable(clazz.cast(this.samAccountName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeGroupRequest, T> g) {
        return obj -> g.apply((DescribeGroupRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryServiceDataRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private List<String> otherAttributes = DefaultSdkAutoConstructList.getInstance();
        private String realm;
        private String samAccountName;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeGroupRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.otherAttributes(model.otherAttributes);
            this.realm(model.realm);
            this.samAccountName(model.samAccountName);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getOtherAttributes() {
            if (this.otherAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.otherAttributes;
        }

        public final void setOtherAttributes(Collection<String> otherAttributes) {
            this.otherAttributes = LdapDisplayNameListCopier.copy(otherAttributes);
        }

        @Override
        public final Builder otherAttributes(Collection<String> otherAttributes) {
            this.otherAttributes = LdapDisplayNameListCopier.copy(otherAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder otherAttributes(String ... otherAttributes) {
            this.otherAttributes(Arrays.asList(otherAttributes));
            return this;
        }

        public final String getRealm() {
            return this.realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getSamAccountName() {
            return this.samAccountName;
        }

        public final void setSamAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
        }

        @Override
        public final Builder samAccountName(String samAccountName) {
            this.samAccountName = samAccountName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeGroupRequest build() {
            return new DescribeGroupRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryServiceDataRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeGroupRequest> {
        public Builder directoryId(String var1);

        public Builder otherAttributes(Collection<String> var1);

        public Builder otherAttributes(String ... var1);

        public Builder realm(String var1);

        public Builder samAccountName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

