/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.HybridAdministratorAccountUpdate;
import software.amazon.awssdk.services.directory.model.HybridCustomerInstancesSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateHybridAdRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, UpdateHybridAdRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(UpdateHybridAdRequest.getter(UpdateHybridAdRequest::directoryId)).setter(UpdateHybridAdRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<HybridAdministratorAccountUpdate> HYBRID_ADMINISTRATOR_ACCOUNT_UPDATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HybridAdministratorAccountUpdate").getter(UpdateHybridAdRequest.getter(UpdateHybridAdRequest::hybridAdministratorAccountUpdate)).setter(UpdateHybridAdRequest.setter(Builder::hybridAdministratorAccountUpdate)).constructor(HybridAdministratorAccountUpdate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HybridAdministratorAccountUpdate").build()}).build();
    private static final SdkField<HybridCustomerInstancesSettings> SELF_MANAGED_INSTANCES_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SelfManagedInstancesSettings").getter(UpdateHybridAdRequest.getter(UpdateHybridAdRequest::selfManagedInstancesSettings)).setter(UpdateHybridAdRequest.setter(Builder::selfManagedInstancesSettings)).constructor(HybridCustomerInstancesSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelfManagedInstancesSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, HYBRID_ADMINISTRATOR_ACCOUNT_UPDATE_FIELD, SELF_MANAGED_INSTANCES_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateHybridAdRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate;
    private final HybridCustomerInstancesSettings selfManagedInstancesSettings;

    private UpdateHybridAdRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.hybridAdministratorAccountUpdate = builder.hybridAdministratorAccountUpdate;
        this.selfManagedInstancesSettings = builder.selfManagedInstancesSettings;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate() {
        return this.hybridAdministratorAccountUpdate;
    }

    public final HybridCustomerInstancesSettings selfManagedInstancesSettings() {
        return this.selfManagedInstancesSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hybridAdministratorAccountUpdate());
        hashCode = 31 * hashCode + Objects.hashCode(this.selfManagedInstancesSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateHybridAdRequest)) {
            return false;
        }
        UpdateHybridAdRequest other = (UpdateHybridAdRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.hybridAdministratorAccountUpdate(), other.hybridAdministratorAccountUpdate()) && Objects.equals(this.selfManagedInstancesSettings(), other.selfManagedInstancesSettings());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateHybridAdRequest").add("DirectoryId", (Object)this.directoryId()).add("HybridAdministratorAccountUpdate", (Object)this.hybridAdministratorAccountUpdate()).add("SelfManagedInstancesSettings", (Object)this.selfManagedInstancesSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "HybridAdministratorAccountUpdate": {
                return Optional.ofNullable(clazz.cast(this.hybridAdministratorAccountUpdate()));
            }
            case "SelfManagedInstancesSettings": {
                return Optional.ofNullable(clazz.cast(this.selfManagedInstancesSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("HybridAdministratorAccountUpdate", HYBRID_ADMINISTRATOR_ACCOUNT_UPDATE_FIELD);
        map.put("SelfManagedInstancesSettings", SELF_MANAGED_INSTANCES_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateHybridAdRequest, T> g) {
        return obj -> g.apply((UpdateHybridAdRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate;
        private HybridCustomerInstancesSettings selfManagedInstancesSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateHybridAdRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.hybridAdministratorAccountUpdate(model.hybridAdministratorAccountUpdate);
            this.selfManagedInstancesSettings(model.selfManagedInstancesSettings);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final HybridAdministratorAccountUpdate.Builder getHybridAdministratorAccountUpdate() {
            return this.hybridAdministratorAccountUpdate != null ? this.hybridAdministratorAccountUpdate.toBuilder() : null;
        }

        public final void setHybridAdministratorAccountUpdate(HybridAdministratorAccountUpdate.BuilderImpl hybridAdministratorAccountUpdate) {
            this.hybridAdministratorAccountUpdate = hybridAdministratorAccountUpdate != null ? hybridAdministratorAccountUpdate.build() : null;
        }

        @Override
        public final Builder hybridAdministratorAccountUpdate(HybridAdministratorAccountUpdate hybridAdministratorAccountUpdate) {
            this.hybridAdministratorAccountUpdate = hybridAdministratorAccountUpdate;
            return this;
        }

        public final HybridCustomerInstancesSettings.Builder getSelfManagedInstancesSettings() {
            return this.selfManagedInstancesSettings != null ? this.selfManagedInstancesSettings.toBuilder() : null;
        }

        public final void setSelfManagedInstancesSettings(HybridCustomerInstancesSettings.BuilderImpl selfManagedInstancesSettings) {
            this.selfManagedInstancesSettings = selfManagedInstancesSettings != null ? selfManagedInstancesSettings.build() : null;
        }

        @Override
        public final Builder selfManagedInstancesSettings(HybridCustomerInstancesSettings selfManagedInstancesSettings) {
            this.selfManagedInstancesSettings = selfManagedInstancesSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateHybridAdRequest build() {
            return new UpdateHybridAdRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateHybridAdRequest> {
        public Builder directoryId(String var1);

        public Builder hybridAdministratorAccountUpdate(HybridAdministratorAccountUpdate var1);

        default public Builder hybridAdministratorAccountUpdate(Consumer<HybridAdministratorAccountUpdate.Builder> hybridAdministratorAccountUpdate) {
            return this.hybridAdministratorAccountUpdate((HybridAdministratorAccountUpdate)((HybridAdministratorAccountUpdate.Builder)HybridAdministratorAccountUpdate.builder().applyMutation(hybridAdministratorAccountUpdate)).build());
        }

        public Builder selfManagedInstancesSettings(HybridCustomerInstancesSettings var1);

        default public Builder selfManagedInstancesSettings(Consumer<HybridCustomerInstancesSettings.Builder> selfManagedInstancesSettings) {
            return this.selfManagedInstancesSettings((HybridCustomerInstancesSettings)((HybridCustomerInstancesSettings.Builder)HybridCustomerInstancesSettings.builder().applyMutation(selfManagedInstancesSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

