/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.CustomerDnsIpsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssessmentSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssessmentSummary> {
    private static final SdkField<String> ASSESSMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AssessmentId").getter(AssessmentSummary.getter(AssessmentSummary::assessmentId)).setter(AssessmentSummary.setter(Builder::assessmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssessmentId").build()}).build();
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(AssessmentSummary.getter(AssessmentSummary::directoryId)).setter(AssessmentSummary.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> DNS_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DnsName").getter(AssessmentSummary.getter(AssessmentSummary::dnsName)).setter(AssessmentSummary.setter(Builder::dnsName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DnsName").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(AssessmentSummary.getter(AssessmentSummary::startTime)).setter(AssessmentSummary.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> LAST_UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastUpdateDateTime").getter(AssessmentSummary.getter(AssessmentSummary::lastUpdateDateTime)).setter(AssessmentSummary.setter(Builder::lastUpdateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdateDateTime").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(AssessmentSummary.getter(AssessmentSummary::status)).setter(AssessmentSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> CUSTOMER_DNS_IPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerDnsIps").getter(AssessmentSummary.getter(AssessmentSummary::customerDnsIps)).setter(AssessmentSummary.setter(Builder::customerDnsIps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerDnsIps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REPORT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReportType").getter(AssessmentSummary.getter(AssessmentSummary::reportType)).setter(AssessmentSummary.setter(Builder::reportType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReportType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSESSMENT_ID_FIELD, DIRECTORY_ID_FIELD, DNS_NAME_FIELD, START_TIME_FIELD, LAST_UPDATE_DATE_TIME_FIELD, STATUS_FIELD, CUSTOMER_DNS_IPS_FIELD, REPORT_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AssessmentSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String assessmentId;
    private final String directoryId;
    private final String dnsName;
    private final Instant startTime;
    private final Instant lastUpdateDateTime;
    private final String status;
    private final List<String> customerDnsIps;
    private final String reportType;

    private AssessmentSummary(BuilderImpl builder) {
        this.assessmentId = builder.assessmentId;
        this.directoryId = builder.directoryId;
        this.dnsName = builder.dnsName;
        this.startTime = builder.startTime;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
        this.status = builder.status;
        this.customerDnsIps = builder.customerDnsIps;
        this.reportType = builder.reportType;
    }

    public final String assessmentId() {
        return this.assessmentId;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final String dnsName() {
        return this.dnsName;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant lastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public final String status() {
        return this.status;
    }

    public final boolean hasCustomerDnsIps() {
        return this.customerDnsIps != null && !(this.customerDnsIps instanceof SdkAutoConstructList);
    }

    public final List<String> customerDnsIps() {
        return this.customerDnsIps;
    }

    public final String reportType() {
        return this.reportType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assessmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dnsName());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerDnsIps() ? this.customerDnsIps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reportType());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssessmentSummary)) {
            return false;
        }
        AssessmentSummary other = (AssessmentSummary)obj;
        return Objects.equals(this.assessmentId(), other.assessmentId()) && Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.dnsName(), other.dnsName()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.lastUpdateDateTime(), other.lastUpdateDateTime()) && Objects.equals(this.status(), other.status()) && this.hasCustomerDnsIps() == other.hasCustomerDnsIps() && Objects.equals(this.customerDnsIps(), other.customerDnsIps()) && Objects.equals(this.reportType(), other.reportType());
    }

    public final String toString() {
        return ToString.builder((String)"AssessmentSummary").add("AssessmentId", (Object)this.assessmentId()).add("DirectoryId", (Object)this.directoryId()).add("DnsName", (Object)this.dnsName()).add("StartTime", (Object)this.startTime()).add("LastUpdateDateTime", (Object)this.lastUpdateDateTime()).add("Status", (Object)this.status()).add("CustomerDnsIps", this.hasCustomerDnsIps() ? this.customerDnsIps() : null).add("ReportType", (Object)this.reportType()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AssessmentId": {
                return Optional.ofNullable(clazz.cast(this.assessmentId()));
            }
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "DnsName": {
                return Optional.ofNullable(clazz.cast(this.dnsName()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "LastUpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDateTime()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "CustomerDnsIps": {
                return Optional.ofNullable(clazz.cast(this.customerDnsIps()));
            }
            case "ReportType": {
                return Optional.ofNullable(clazz.cast(this.reportType()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AssessmentId", ASSESSMENT_ID_FIELD);
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("DnsName", DNS_NAME_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("LastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("CustomerDnsIps", CUSTOMER_DNS_IPS_FIELD);
        map.put("ReportType", REPORT_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssessmentSummary, T> g) {
        return obj -> g.apply((AssessmentSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assessmentId;
        private String directoryId;
        private String dnsName;
        private Instant startTime;
        private Instant lastUpdateDateTime;
        private String status;
        private List<String> customerDnsIps = DefaultSdkAutoConstructList.getInstance();
        private String reportType;

        private BuilderImpl() {
        }

        private BuilderImpl(AssessmentSummary model) {
            this.assessmentId(model.assessmentId);
            this.directoryId(model.directoryId);
            this.dnsName(model.dnsName);
            this.startTime(model.startTime);
            this.lastUpdateDateTime(model.lastUpdateDateTime);
            this.status(model.status);
            this.customerDnsIps(model.customerDnsIps);
            this.reportType(model.reportType);
        }

        public final String getAssessmentId() {
            return this.assessmentId;
        }

        public final void setAssessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
        }

        @Override
        public final Builder assessmentId(String assessmentId) {
            this.assessmentId = assessmentId;
            return this;
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getDnsName() {
            return this.dnsName;
        }

        public final void setDnsName(String dnsName) {
            this.dnsName = dnsName;
        }

        @Override
        public final Builder dnsName(String dnsName) {
            this.dnsName = dnsName;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getLastUpdateDateTime() {
            return this.lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(Instant lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getCustomerDnsIps() {
            if (this.customerDnsIps instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerDnsIps;
        }

        public final void setCustomerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = CustomerDnsIpsCopier.copy(customerDnsIps);
        }

        @Override
        public final Builder customerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = CustomerDnsIpsCopier.copy(customerDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerDnsIps(String ... customerDnsIps) {
            this.customerDnsIps(Arrays.asList(customerDnsIps));
            return this;
        }

        public final String getReportType() {
            return this.reportType;
        }

        public final void setReportType(String reportType) {
            this.reportType = reportType;
        }

        @Override
        public final Builder reportType(String reportType) {
            this.reportType = reportType;
            return this;
        }

        public AssessmentSummary build() {
            return new AssessmentSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssessmentSummary> {
        public Builder assessmentId(String var1);

        public Builder directoryId(String var1);

        public Builder dnsName(String var1);

        public Builder startTime(Instant var1);

        public Builder lastUpdateDateTime(Instant var1);

        public Builder status(String var1);

        public Builder customerDnsIps(Collection<String> var1);

        public Builder customerDnsIps(String ... var1);

        public Builder reportType(String var1);
    }
}

