/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.HybridUpdateType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHybridAdUpdateRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, DescribeHybridAdUpdateRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DirectoryId").getter(DescribeHybridAdUpdateRequest.getter(DescribeHybridAdUpdateRequest::directoryId)).setter(DescribeHybridAdUpdateRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UpdateType").getter(DescribeHybridAdUpdateRequest.getter(DescribeHybridAdUpdateRequest::updateTypeAsString)).setter(DescribeHybridAdUpdateRequest.setter(Builder::updateType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateType").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeHybridAdUpdateRequest.getter(DescribeHybridAdUpdateRequest::nextToken)).setter(DescribeHybridAdUpdateRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, UPDATE_TYPE_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeHybridAdUpdateRequest.memberNameToFieldInitializer();
    private final String directoryId;
    private final String updateType;
    private final String nextToken;

    private DescribeHybridAdUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.updateType = builder.updateType;
        this.nextToken = builder.nextToken;
    }

    public final String directoryId() {
        return this.directoryId;
    }

    public final HybridUpdateType updateType() {
        return HybridUpdateType.fromValue(this.updateType);
    }

    public final String updateTypeAsString() {
        return this.updateType;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHybridAdUpdateRequest)) {
            return false;
        }
        DescribeHybridAdUpdateRequest other = (DescribeHybridAdUpdateRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.updateTypeAsString(), other.updateTypeAsString()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHybridAdUpdateRequest").add("DirectoryId", (Object)this.directoryId()).add("UpdateType", (Object)this.updateTypeAsString()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "UpdateType": {
                return Optional.ofNullable(clazz.cast(this.updateTypeAsString()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("DirectoryId", DIRECTORY_ID_FIELD);
        map.put("UpdateType", UPDATE_TYPE_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeHybridAdUpdateRequest, T> g) {
        return obj -> g.apply((DescribeHybridAdUpdateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String updateType;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHybridAdUpdateRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.updateType(model.updateType);
            this.nextToken(model.nextToken);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final String getUpdateType() {
            return this.updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        public final Builder updateType(HybridUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeHybridAdUpdateRequest build() {
            return new DescribeHybridAdUpdateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHybridAdUpdateRequest> {
        public Builder directoryId(String var1);

        public Builder updateType(String var1);

        public Builder updateType(HybridUpdateType var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

