/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.services.directory.model.LDAPSSettingInfo;
import software.amazon.awssdk.services.directory.model.LDAPSSettingsInfoCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLdapsSettingsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeLdapsSettingsResponse> {
    private static final SdkField<List<LDAPSSettingInfo>> LDAPS_SETTINGS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LDAPSSettingsInfo").getter(DescribeLdapsSettingsResponse.getter(DescribeLdapsSettingsResponse::ldapsSettingsInfo)).setter(DescribeLdapsSettingsResponse.setter(Builder::ldapsSettingsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LDAPSSettingsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LDAPSSettingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeLdapsSettingsResponse.getter(DescribeLdapsSettingsResponse::nextToken)).setter(DescribeLdapsSettingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LDAPS_SETTINGS_INFO_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LDAPSSettingsInfo", LDAPS_SETTINGS_INFO_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<LDAPSSettingInfo> ldapsSettingsInfo;
    private final String nextToken;

    private DescribeLdapsSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.ldapsSettingsInfo = builder.ldapsSettingsInfo;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLdapsSettingsInfo() {
        return this.ldapsSettingsInfo != null && !(this.ldapsSettingsInfo instanceof SdkAutoConstructList);
    }

    public final List<LDAPSSettingInfo> ldapsSettingsInfo() {
        return this.ldapsSettingsInfo;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLdapsSettingsInfo() ? this.ldapsSettingsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLdapsSettingsResponse)) {
            return false;
        }
        DescribeLdapsSettingsResponse other = (DescribeLdapsSettingsResponse)((Object)obj);
        return this.hasLdapsSettingsInfo() == other.hasLdapsSettingsInfo() && Objects.equals(this.ldapsSettingsInfo(), other.ldapsSettingsInfo()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLdapsSettingsResponse").add("LDAPSSettingsInfo", this.hasLdapsSettingsInfo() ? this.ldapsSettingsInfo() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LDAPSSettingsInfo": {
                return Optional.ofNullable(clazz.cast(this.ldapsSettingsInfo()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLdapsSettingsResponse, T> g) {
        return obj -> g.apply((DescribeLdapsSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<LDAPSSettingInfo> ldapsSettingsInfo = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLdapsSettingsResponse model) {
            super(model);
            this.ldapsSettingsInfo(model.ldapsSettingsInfo);
            this.nextToken(model.nextToken);
        }

        public final List<LDAPSSettingInfo.Builder> getLdapsSettingsInfo() {
            List<LDAPSSettingInfo.Builder> result = LDAPSSettingsInfoCopier.copyToBuilder(this.ldapsSettingsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLdapsSettingsInfo(Collection<LDAPSSettingInfo.BuilderImpl> ldapsSettingsInfo) {
            this.ldapsSettingsInfo = LDAPSSettingsInfoCopier.copyFromBuilder(ldapsSettingsInfo);
        }

        @Override
        public final Builder ldapsSettingsInfo(Collection<LDAPSSettingInfo> ldapsSettingsInfo) {
            this.ldapsSettingsInfo = LDAPSSettingsInfoCopier.copy(ldapsSettingsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ldapsSettingsInfo(LDAPSSettingInfo ... ldapsSettingsInfo) {
            this.ldapsSettingsInfo(Arrays.asList(ldapsSettingsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ldapsSettingsInfo(Consumer<LDAPSSettingInfo.Builder> ... ldapsSettingsInfo) {
            this.ldapsSettingsInfo(Stream.of(ldapsSettingsInfo).map(c -> (LDAPSSettingInfo)((LDAPSSettingInfo.Builder)LDAPSSettingInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeLdapsSettingsResponse build() {
            return new DescribeLdapsSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLdapsSettingsResponse> {
        public Builder ldapsSettingsInfo(Collection<LDAPSSettingInfo> var1);

        public Builder ldapsSettingsInfo(LDAPSSettingInfo ... var1);

        public Builder ldapsSettingsInfo(Consumer<LDAPSSettingInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

