/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.ClientAuthenticationSettingInfo;
import software.amazon.awssdk.services.directory.model.ClientAuthenticationSettingsInfoCopier;
import software.amazon.awssdk.services.directory.model.DirectoryResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClientAuthenticationSettingsResponse
extends DirectoryResponse
implements ToCopyableBuilder<Builder, DescribeClientAuthenticationSettingsResponse> {
    private static final SdkField<List<ClientAuthenticationSettingInfo>> CLIENT_AUTHENTICATION_SETTINGS_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClientAuthenticationSettingsInfo").getter(DescribeClientAuthenticationSettingsResponse.getter(DescribeClientAuthenticationSettingsResponse::clientAuthenticationSettingsInfo)).setter(DescribeClientAuthenticationSettingsResponse.setter(Builder::clientAuthenticationSettingsInfo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientAuthenticationSettingsInfo").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClientAuthenticationSettingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeClientAuthenticationSettingsResponse.getter(DescribeClientAuthenticationSettingsResponse::nextToken)).setter(DescribeClientAuthenticationSettingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_AUTHENTICATION_SETTINGS_INFO_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeClientAuthenticationSettingsResponse.memberNameToFieldInitializer();
    private final List<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo;
    private final String nextToken;

    private DescribeClientAuthenticationSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.clientAuthenticationSettingsInfo = builder.clientAuthenticationSettingsInfo;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasClientAuthenticationSettingsInfo() {
        return this.clientAuthenticationSettingsInfo != null && !(this.clientAuthenticationSettingsInfo instanceof SdkAutoConstructList);
    }

    public final List<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo() {
        return this.clientAuthenticationSettingsInfo;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClientAuthenticationSettingsInfo() ? this.clientAuthenticationSettingsInfo() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClientAuthenticationSettingsResponse)) {
            return false;
        }
        DescribeClientAuthenticationSettingsResponse other = (DescribeClientAuthenticationSettingsResponse)((Object)obj);
        return this.hasClientAuthenticationSettingsInfo() == other.hasClientAuthenticationSettingsInfo() && Objects.equals(this.clientAuthenticationSettingsInfo(), other.clientAuthenticationSettingsInfo()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClientAuthenticationSettingsResponse").add("ClientAuthenticationSettingsInfo", this.hasClientAuthenticationSettingsInfo() ? this.clientAuthenticationSettingsInfo() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientAuthenticationSettingsInfo": {
                return Optional.ofNullable(clazz.cast(this.clientAuthenticationSettingsInfo()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientAuthenticationSettingsInfo", CLIENT_AUTHENTICATION_SETTINGS_INFO_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeClientAuthenticationSettingsResponse, T> g) {
        return obj -> g.apply((DescribeClientAuthenticationSettingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryResponse.BuilderImpl
    implements Builder {
        private List<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClientAuthenticationSettingsResponse model) {
            super(model);
            this.clientAuthenticationSettingsInfo(model.clientAuthenticationSettingsInfo);
            this.nextToken(model.nextToken);
        }

        public final List<ClientAuthenticationSettingInfo.Builder> getClientAuthenticationSettingsInfo() {
            List<ClientAuthenticationSettingInfo.Builder> result = ClientAuthenticationSettingsInfoCopier.copyToBuilder(this.clientAuthenticationSettingsInfo);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClientAuthenticationSettingsInfo(Collection<ClientAuthenticationSettingInfo.BuilderImpl> clientAuthenticationSettingsInfo) {
            this.clientAuthenticationSettingsInfo = ClientAuthenticationSettingsInfoCopier.copyFromBuilder(clientAuthenticationSettingsInfo);
        }

        @Override
        public final Builder clientAuthenticationSettingsInfo(Collection<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo) {
            this.clientAuthenticationSettingsInfo = ClientAuthenticationSettingsInfoCopier.copy(clientAuthenticationSettingsInfo);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientAuthenticationSettingsInfo(ClientAuthenticationSettingInfo ... clientAuthenticationSettingsInfo) {
            this.clientAuthenticationSettingsInfo(Arrays.asList(clientAuthenticationSettingsInfo));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clientAuthenticationSettingsInfo(Consumer<ClientAuthenticationSettingInfo.Builder> ... clientAuthenticationSettingsInfo) {
            this.clientAuthenticationSettingsInfo(Stream.of(clientAuthenticationSettingsInfo).map(c -> (ClientAuthenticationSettingInfo)((ClientAuthenticationSettingInfo.Builder)ClientAuthenticationSettingInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeClientAuthenticationSettingsResponse build() {
            return new DescribeClientAuthenticationSettingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectoryResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClientAuthenticationSettingsResponse> {
        public Builder clientAuthenticationSettingsInfo(Collection<ClientAuthenticationSettingInfo> var1);

        public Builder clientAuthenticationSettingsInfo(ClientAuthenticationSettingInfo ... var1);

        public Builder clientAuthenticationSettingsInfo(Consumer<ClientAuthenticationSettingInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

