/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeLdapsSettingsResponse;
import software.amazon.awssdk.services.directory.model.LDAPSSettingInfo;

public class DescribeLDAPSSettingsPublisher
implements SdkPublisher<DescribeLdapsSettingsResponse> {
    private final DirectoryAsyncClient client;
    private final DescribeLdapsSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeLDAPSSettingsPublisher(DirectoryAsyncClient client, DescribeLdapsSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeLDAPSSettingsPublisher(DirectoryAsyncClient client, DescribeLdapsSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeLdapsSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeLdapsSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LDAPSSettingInfo> ldapsSettingsInfo() {
        Function<DescribeLdapsSettingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.ldapsSettingsInfo() != null) {
                return response.ldapsSettingsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeLdapsSettingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeLdapsSettingsResponseFetcher
    implements AsyncPageFetcher<DescribeLdapsSettingsResponse> {
        private DescribeLdapsSettingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLdapsSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeLdapsSettingsResponse> nextPage(DescribeLdapsSettingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeLDAPSSettingsPublisher.this.client.describeLDAPSSettings(DescribeLDAPSSettingsPublisher.this.firstRequest);
            }
            return DescribeLDAPSSettingsPublisher.this.client.describeLDAPSSettings((DescribeLdapsSettingsRequest)((Object)DescribeLDAPSSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

