/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.model.ClientAuthenticationSettingInfo;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsRequest;
import software.amazon.awssdk.services.directory.model.DescribeClientAuthenticationSettingsResponse;

public class DescribeClientAuthenticationSettingsPublisher
implements SdkPublisher<DescribeClientAuthenticationSettingsResponse> {
    private final DirectoryAsyncClient client;
    private final DescribeClientAuthenticationSettingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClientAuthenticationSettingsPublisher(DirectoryAsyncClient client, DescribeClientAuthenticationSettingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClientAuthenticationSettingsPublisher(DirectoryAsyncClient client, DescribeClientAuthenticationSettingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClientAuthenticationSettingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClientAuthenticationSettingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ClientAuthenticationSettingInfo> clientAuthenticationSettingsInfo() {
        Function<DescribeClientAuthenticationSettingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.clientAuthenticationSettingsInfo() != null) {
                return response.clientAuthenticationSettingsInfo().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClientAuthenticationSettingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeClientAuthenticationSettingsResponseFetcher
    implements AsyncPageFetcher<DescribeClientAuthenticationSettingsResponse> {
        private DescribeClientAuthenticationSettingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClientAuthenticationSettingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeClientAuthenticationSettingsResponse> nextPage(DescribeClientAuthenticationSettingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeClientAuthenticationSettingsPublisher.this.client.describeClientAuthenticationSettings(DescribeClientAuthenticationSettingsPublisher.this.firstRequest);
            }
            return DescribeClientAuthenticationSettingsPublisher.this.client.describeClientAuthenticationSettings((DescribeClientAuthenticationSettingsRequest)((Object)DescribeClientAuthenticationSettingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

