/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.directory.DirectoryAsyncClient;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesRequest;
import software.amazon.awssdk.services.directory.model.DescribeDirectoriesResponse;
import software.amazon.awssdk.services.directory.model.DirectoryDescription;

public class DescribeDirectoriesPublisher
implements SdkPublisher<DescribeDirectoriesResponse> {
    private final DirectoryAsyncClient client;
    private final DescribeDirectoriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeDirectoriesPublisher(DirectoryAsyncClient client, DescribeDirectoriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeDirectoriesPublisher(DirectoryAsyncClient client, DescribeDirectoriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeDirectoriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeDirectoriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<DirectoryDescription> directoryDescriptions() {
        Function<DescribeDirectoriesResponse, Iterator> getIterator = response -> {
            if (response != null && response.directoryDescriptions() != null) {
                return response.directoryDescriptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeDirectoriesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeDirectoriesResponseFetcher
    implements AsyncPageFetcher<DescribeDirectoriesResponse> {
        private DescribeDirectoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeDirectoriesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeDirectoriesResponse> nextPage(DescribeDirectoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeDirectoriesPublisher.this.client.describeDirectories(DescribeDirectoriesPublisher.this.firstRequest);
            }
            return DescribeDirectoriesPublisher.this.client.describeDirectories((DescribeDirectoriesRequest)((Object)DescribeDirectoriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

