/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the Regions that are configured for multi-Region replication.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegionsInfo implements SdkPojo, Serializable, ToCopyableBuilder<RegionsInfo.Builder, RegionsInfo> {
    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PrimaryRegion").getter(getter(RegionsInfo::primaryRegion)).setter(setter(Builder::primaryRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryRegion").build()).build();

    private static final SdkField<List<String>> ADDITIONAL_REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdditionalRegions")
            .getter(getter(RegionsInfo::additionalRegions))
            .setter(setter(Builder::additionalRegions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalRegions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRIMARY_REGION_FIELD,
            ADDITIONAL_REGIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String primaryRegion;

    private final List<String> additionalRegions;

    private RegionsInfo(BuilderImpl builder) {
        this.primaryRegion = builder.primaryRegion;
        this.additionalRegions = builder.additionalRegions;
    }

    /**
     * <p>
     * The Region where the AWS Managed Microsoft AD directory was originally created.
     * </p>
     * 
     * @return The Region where the AWS Managed Microsoft AD directory was originally created.
     */
    public final String primaryRegion() {
        return primaryRegion;
    }

    /**
     * Returns true if the AdditionalRegions property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasAdditionalRegions() {
        return additionalRegions != null && !(additionalRegions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists the Regions where the directory has been replicated, excluding the primary Region.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAdditionalRegions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Lists the Regions where the directory has been replicated, excluding the primary Region.
     */
    public final List<String> additionalRegions() {
        return additionalRegions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdditionalRegions() ? additionalRegions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegionsInfo)) {
            return false;
        }
        RegionsInfo other = (RegionsInfo) obj;
        return Objects.equals(primaryRegion(), other.primaryRegion()) && hasAdditionalRegions() == other.hasAdditionalRegions()
                && Objects.equals(additionalRegions(), other.additionalRegions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegionsInfo").add("PrimaryRegion", primaryRegion())
                .add("AdditionalRegions", hasAdditionalRegions() ? additionalRegions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PrimaryRegion":
            return Optional.ofNullable(clazz.cast(primaryRegion()));
        case "AdditionalRegions":
            return Optional.ofNullable(clazz.cast(additionalRegions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegionsInfo, T> g) {
        return obj -> g.apply((RegionsInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegionsInfo> {
        /**
         * <p>
         * The Region where the AWS Managed Microsoft AD directory was originally created.
         * </p>
         * 
         * @param primaryRegion
         *        The Region where the AWS Managed Microsoft AD directory was originally created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryRegion(String primaryRegion);

        /**
         * <p>
         * Lists the Regions where the directory has been replicated, excluding the primary Region.
         * </p>
         * 
         * @param additionalRegions
         *        Lists the Regions where the directory has been replicated, excluding the primary Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalRegions(Collection<String> additionalRegions);

        /**
         * <p>
         * Lists the Regions where the directory has been replicated, excluding the primary Region.
         * </p>
         * 
         * @param additionalRegions
         *        Lists the Regions where the directory has been replicated, excluding the primary Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalRegions(String... additionalRegions);
    }

    static final class BuilderImpl implements Builder {
        private String primaryRegion;

        private List<String> additionalRegions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RegionsInfo model) {
            primaryRegion(model.primaryRegion);
            additionalRegions(model.additionalRegions);
        }

        public final String getPrimaryRegion() {
            return primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        public final Collection<String> getAdditionalRegions() {
            if (additionalRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return additionalRegions;
        }

        @Override
        public final Builder additionalRegions(Collection<String> additionalRegions) {
            this.additionalRegions = AdditionalRegionsCopier.copy(additionalRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalRegions(String... additionalRegions) {
            additionalRegions(Arrays.asList(additionalRegions));
            return this;
        }

        public final void setAdditionalRegions(Collection<String> additionalRegions) {
            this.additionalRegions = AdditionalRegionsCopier.copy(additionalRegions);
        }

        @Override
        public RegionsInfo build() {
            return new RegionsInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
