/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the results of the <a>GetDirectoryLimits</a> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetDirectoryLimitsResponse extends DirectoryResponse implements
        ToCopyableBuilder<GetDirectoryLimitsResponse.Builder, GetDirectoryLimitsResponse> {
    private static final SdkField<DirectoryLimits> DIRECTORY_LIMITS_FIELD = SdkField
            .<DirectoryLimits> builder(MarshallingType.SDK_POJO).memberName("DirectoryLimits")
            .getter(getter(GetDirectoryLimitsResponse::directoryLimits)).setter(setter(Builder::directoryLimits))
            .constructor(DirectoryLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryLimits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_LIMITS_FIELD));

    private final DirectoryLimits directoryLimits;

    private GetDirectoryLimitsResponse(BuilderImpl builder) {
        super(builder);
        this.directoryLimits = builder.directoryLimits;
    }

    /**
     * <p>
     * A <a>DirectoryLimits</a> object that contains the directory limits for the current rRegion.
     * </p>
     * 
     * @return A <a>DirectoryLimits</a> object that contains the directory limits for the current rRegion.
     */
    public final DirectoryLimits directoryLimits() {
        return directoryLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryLimits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDirectoryLimitsResponse)) {
            return false;
        }
        GetDirectoryLimitsResponse other = (GetDirectoryLimitsResponse) obj;
        return Objects.equals(directoryLimits(), other.directoryLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetDirectoryLimitsResponse").add("DirectoryLimits", directoryLimits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryLimits":
            return Optional.ofNullable(clazz.cast(directoryLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetDirectoryLimitsResponse, T> g) {
        return obj -> g.apply((GetDirectoryLimitsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetDirectoryLimitsResponse> {
        /**
         * <p>
         * A <a>DirectoryLimits</a> object that contains the directory limits for the current rRegion.
         * </p>
         * 
         * @param directoryLimits
         *        A <a>DirectoryLimits</a> object that contains the directory limits for the current rRegion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryLimits(DirectoryLimits directoryLimits);

        /**
         * <p>
         * A <a>DirectoryLimits</a> object that contains the directory limits for the current rRegion.
         * </p>
         * This is a convenience that creates an instance of the {@link DirectoryLimits.Builder} avoiding the need to
         * create one manually via {@link DirectoryLimits#builder()}.
         *
         * When the {@link Consumer} completes, {@link DirectoryLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #directoryLimits(DirectoryLimits)}.
         * 
         * @param directoryLimits
         *        a consumer that will call methods on {@link DirectoryLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directoryLimits(DirectoryLimits)
         */
        default Builder directoryLimits(Consumer<DirectoryLimits.Builder> directoryLimits) {
            return directoryLimits(DirectoryLimits.builder().applyMutation(directoryLimits).build());
        }
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private DirectoryLimits directoryLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDirectoryLimitsResponse model) {
            super(model);
            directoryLimits(model.directoryLimits);
        }

        public final DirectoryLimits.Builder getDirectoryLimits() {
            return directoryLimits != null ? directoryLimits.toBuilder() : null;
        }

        @Override
        public final Builder directoryLimits(DirectoryLimits directoryLimits) {
            this.directoryLimits = directoryLimits;
            return this;
        }

        public final void setDirectoryLimits(DirectoryLimits.BuilderImpl directoryLimits) {
            this.directoryLimits = directoryLimits != null ? directoryLimits.build() : null;
        }

        @Override
        public GetDirectoryLimitsResponse build() {
            return new GetDirectoryLimitsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
