/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceptSharedDirectoryResponse extends DirectoryResponse implements
        ToCopyableBuilder<AcceptSharedDirectoryResponse.Builder, AcceptSharedDirectoryResponse> {
    private static final SdkField<SharedDirectory> SHARED_DIRECTORY_FIELD = SdkField
            .<SharedDirectory> builder(MarshallingType.SDK_POJO).memberName("SharedDirectory")
            .getter(getter(AcceptSharedDirectoryResponse::sharedDirectory)).setter(setter(Builder::sharedDirectory))
            .constructor(SharedDirectory::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SharedDirectory").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARED_DIRECTORY_FIELD));

    private final SharedDirectory sharedDirectory;

    private AcceptSharedDirectoryResponse(BuilderImpl builder) {
        super(builder);
        this.sharedDirectory = builder.sharedDirectory;
    }

    /**
     * <p>
     * The shared directory in the directory consumer account.
     * </p>
     * 
     * @return The shared directory in the directory consumer account.
     */
    public final SharedDirectory sharedDirectory() {
        return sharedDirectory;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sharedDirectory());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptSharedDirectoryResponse)) {
            return false;
        }
        AcceptSharedDirectoryResponse other = (AcceptSharedDirectoryResponse) obj;
        return Objects.equals(sharedDirectory(), other.sharedDirectory());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceptSharedDirectoryResponse").add("SharedDirectory", sharedDirectory()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SharedDirectory":
            return Optional.ofNullable(clazz.cast(sharedDirectory()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AcceptSharedDirectoryResponse, T> g) {
        return obj -> g.apply((AcceptSharedDirectoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryResponse.Builder, SdkPojo, CopyableBuilder<Builder, AcceptSharedDirectoryResponse> {
        /**
         * <p>
         * The shared directory in the directory consumer account.
         * </p>
         * 
         * @param sharedDirectory
         *        The shared directory in the directory consumer account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedDirectory(SharedDirectory sharedDirectory);

        /**
         * <p>
         * The shared directory in the directory consumer account.
         * </p>
         * This is a convenience that creates an instance of the {@link SharedDirectory.Builder} avoiding the need to
         * create one manually via {@link SharedDirectory#builder()}.
         *
         * When the {@link Consumer} completes, {@link SharedDirectory.Builder#build()} is called immediately and its
         * result is passed to {@link #sharedDirectory(SharedDirectory)}.
         * 
         * @param sharedDirectory
         *        a consumer that will call methods on {@link SharedDirectory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sharedDirectory(SharedDirectory)
         */
        default Builder sharedDirectory(Consumer<SharedDirectory.Builder> sharedDirectory) {
            return sharedDirectory(SharedDirectory.builder().applyMutation(sharedDirectory).build());
        }
    }

    static final class BuilderImpl extends DirectoryResponse.BuilderImpl implements Builder {
        private SharedDirectory sharedDirectory;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptSharedDirectoryResponse model) {
            super(model);
            sharedDirectory(model.sharedDirectory);
        }

        public final SharedDirectory.Builder getSharedDirectory() {
            return sharedDirectory != null ? sharedDirectory.toBuilder() : null;
        }

        @Override
        public final Builder sharedDirectory(SharedDirectory sharedDirectory) {
            this.sharedDirectory = sharedDirectory;
            return this;
        }

        public final void setSharedDirectory(SharedDirectory.BuilderImpl sharedDirectory) {
            this.sharedDirectory = sharedDirectory != null ? sharedDirectory.build() : null;
        }

        @Override
        public AcceptSharedDirectoryResponse build() {
            return new AcceptSharedDirectoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
