/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directory.model.IpRouteStatusMsg;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IpRouteInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IpRouteInfo> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IpRouteInfo.getter(IpRouteInfo::directoryId)).setter(IpRouteInfo.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> CIDR_IP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IpRouteInfo.getter(IpRouteInfo::cidrIp)).setter(IpRouteInfo.setter(Builder::cidrIp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CidrIp").build()}).build();
    private static final SdkField<String> IP_ROUTE_STATUS_MSG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IpRouteInfo.getter(IpRouteInfo::ipRouteStatusMsgAsString)).setter(IpRouteInfo.setter(Builder::ipRouteStatusMsg)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRouteStatusMsg").build()}).build();
    private static final SdkField<Instant> ADDED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(IpRouteInfo.getter(IpRouteInfo::addedDateTime)).setter(IpRouteInfo.setter(Builder::addedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AddedDateTime").build()}).build();
    private static final SdkField<String> IP_ROUTE_STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IpRouteInfo.getter(IpRouteInfo::ipRouteStatusReason)).setter(IpRouteInfo.setter(Builder::ipRouteStatusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpRouteStatusReason").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(IpRouteInfo.getter(IpRouteInfo::description)).setter(IpRouteInfo.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, CIDR_IP_FIELD, IP_ROUTE_STATUS_MSG_FIELD, ADDED_DATE_TIME_FIELD, IP_ROUTE_STATUS_REASON_FIELD, DESCRIPTION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String directoryId;
    private final String cidrIp;
    private final String ipRouteStatusMsg;
    private final Instant addedDateTime;
    private final String ipRouteStatusReason;
    private final String description;

    private IpRouteInfo(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.cidrIp = builder.cidrIp;
        this.ipRouteStatusMsg = builder.ipRouteStatusMsg;
        this.addedDateTime = builder.addedDateTime;
        this.ipRouteStatusReason = builder.ipRouteStatusReason;
        this.description = builder.description;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String cidrIp() {
        return this.cidrIp;
    }

    public IpRouteStatusMsg ipRouteStatusMsg() {
        return IpRouteStatusMsg.fromValue(this.ipRouteStatusMsg);
    }

    public String ipRouteStatusMsgAsString() {
        return this.ipRouteStatusMsg;
    }

    public Instant addedDateTime() {
        return this.addedDateTime;
    }

    public String ipRouteStatusReason() {
        return this.ipRouteStatusReason;
    }

    public String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cidrIp());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipRouteStatusMsgAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.addedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipRouteStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpRouteInfo)) {
            return false;
        }
        IpRouteInfo other = (IpRouteInfo)obj;
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.cidrIp(), other.cidrIp()) && Objects.equals(this.ipRouteStatusMsgAsString(), other.ipRouteStatusMsgAsString()) && Objects.equals(this.addedDateTime(), other.addedDateTime()) && Objects.equals(this.ipRouteStatusReason(), other.ipRouteStatusReason()) && Objects.equals(this.description(), other.description());
    }

    public String toString() {
        return ToString.builder((String)"IpRouteInfo").add("DirectoryId", (Object)this.directoryId()).add("CidrIp", (Object)this.cidrIp()).add("IpRouteStatusMsg", (Object)this.ipRouteStatusMsgAsString()).add("AddedDateTime", (Object)this.addedDateTime()).add("IpRouteStatusReason", (Object)this.ipRouteStatusReason()).add("Description", (Object)this.description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "CidrIp": {
                return Optional.ofNullable(clazz.cast(this.cidrIp()));
            }
            case "IpRouteStatusMsg": {
                return Optional.ofNullable(clazz.cast(this.ipRouteStatusMsgAsString()));
            }
            case "AddedDateTime": {
                return Optional.ofNullable(clazz.cast(this.addedDateTime()));
            }
            case "IpRouteStatusReason": {
                return Optional.ofNullable(clazz.cast(this.ipRouteStatusReason()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IpRouteInfo, T> g) {
        return obj -> g.apply((IpRouteInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String directoryId;
        private String cidrIp;
        private String ipRouteStatusMsg;
        private Instant addedDateTime;
        private String ipRouteStatusReason;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(IpRouteInfo model) {
            this.directoryId(model.directoryId);
            this.cidrIp(model.cidrIp);
            this.ipRouteStatusMsg(model.ipRouteStatusMsg);
            this.addedDateTime(model.addedDateTime);
            this.ipRouteStatusReason(model.ipRouteStatusReason);
            this.description(model.description);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getCidrIp() {
            return this.cidrIp;
        }

        @Override
        public final Builder cidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
            return this;
        }

        public final void setCidrIp(String cidrIp) {
            this.cidrIp = cidrIp;
        }

        public final String getIpRouteStatusMsg() {
            return this.ipRouteStatusMsg;
        }

        @Override
        public final Builder ipRouteStatusMsg(String ipRouteStatusMsg) {
            this.ipRouteStatusMsg = ipRouteStatusMsg;
            return this;
        }

        @Override
        public final Builder ipRouteStatusMsg(IpRouteStatusMsg ipRouteStatusMsg) {
            this.ipRouteStatusMsg(ipRouteStatusMsg == null ? null : ipRouteStatusMsg.toString());
            return this;
        }

        public final void setIpRouteStatusMsg(String ipRouteStatusMsg) {
            this.ipRouteStatusMsg = ipRouteStatusMsg;
        }

        public final Instant getAddedDateTime() {
            return this.addedDateTime;
        }

        @Override
        public final Builder addedDateTime(Instant addedDateTime) {
            this.addedDateTime = addedDateTime;
            return this;
        }

        public final void setAddedDateTime(Instant addedDateTime) {
            this.addedDateTime = addedDateTime;
        }

        public final String getIpRouteStatusReason() {
            return this.ipRouteStatusReason;
        }

        @Override
        public final Builder ipRouteStatusReason(String ipRouteStatusReason) {
            this.ipRouteStatusReason = ipRouteStatusReason;
            return this;
        }

        public final void setIpRouteStatusReason(String ipRouteStatusReason) {
            this.ipRouteStatusReason = ipRouteStatusReason;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public IpRouteInfo build() {
            return new IpRouteInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IpRouteInfo> {
        public Builder directoryId(String var1);

        public Builder cidrIp(String var1);

        public Builder ipRouteStatusMsg(String var1);

        public Builder ipRouteStatusMsg(IpRouteStatusMsg var1);

        public Builder addedDateTime(Instant var1);

        public Builder ipRouteStatusReason(String var1);

        public Builder description(String var1);
    }
}

