/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directory.model.DirectoryRequest;
import software.amazon.awssdk.services.directory.model.DnsIpAddrsCopier;
import software.amazon.awssdk.services.directory.model.SelectiveAuth;
import software.amazon.awssdk.services.directory.model.TrustDirection;
import software.amazon.awssdk.services.directory.model.TrustType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrustRequest
extends DirectoryRequest
implements ToCopyableBuilder<Builder, CreateTrustRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrustRequest.getter(CreateTrustRequest::directoryId)).setter(CreateTrustRequest.setter(Builder::directoryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()}).build();
    private static final SdkField<String> REMOTE_DOMAIN_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrustRequest.getter(CreateTrustRequest::remoteDomainName)).setter(CreateTrustRequest.setter(Builder::remoteDomainName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RemoteDomainName").build()}).build();
    private static final SdkField<String> TRUST_PASSWORD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrustRequest.getter(CreateTrustRequest::trustPassword)).setter(CreateTrustRequest.setter(Builder::trustPassword)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustPassword").build()}).build();
    private static final SdkField<String> TRUST_DIRECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrustRequest.getter(CreateTrustRequest::trustDirectionAsString)).setter(CreateTrustRequest.setter(Builder::trustDirection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustDirection").build()}).build();
    private static final SdkField<String> TRUST_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrustRequest.getter(CreateTrustRequest::trustTypeAsString)).setter(CreateTrustRequest.setter(Builder::trustType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrustType").build()}).build();
    private static final SdkField<List<String>> CONDITIONAL_FORWARDER_IP_ADDRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTrustRequest.getter(CreateTrustRequest::conditionalForwarderIpAddrs)).setter(CreateTrustRequest.setter(Builder::conditionalForwarderIpAddrs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConditionalForwarderIpAddrs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SELECTIVE_AUTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrustRequest.getter(CreateTrustRequest::selectiveAuthAsString)).setter(CreateTrustRequest.setter(Builder::selectiveAuth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectiveAuth").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD, REMOTE_DOMAIN_NAME_FIELD, TRUST_PASSWORD_FIELD, TRUST_DIRECTION_FIELD, TRUST_TYPE_FIELD, CONDITIONAL_FORWARDER_IP_ADDRS_FIELD, SELECTIVE_AUTH_FIELD));
    private final String directoryId;
    private final String remoteDomainName;
    private final String trustPassword;
    private final String trustDirection;
    private final String trustType;
    private final List<String> conditionalForwarderIpAddrs;
    private final String selectiveAuth;

    private CreateTrustRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.remoteDomainName = builder.remoteDomainName;
        this.trustPassword = builder.trustPassword;
        this.trustDirection = builder.trustDirection;
        this.trustType = builder.trustType;
        this.conditionalForwarderIpAddrs = builder.conditionalForwarderIpAddrs;
        this.selectiveAuth = builder.selectiveAuth;
    }

    public String directoryId() {
        return this.directoryId;
    }

    public String remoteDomainName() {
        return this.remoteDomainName;
    }

    public String trustPassword() {
        return this.trustPassword;
    }

    public TrustDirection trustDirection() {
        return TrustDirection.fromValue(this.trustDirection);
    }

    public String trustDirectionAsString() {
        return this.trustDirection;
    }

    public TrustType trustType() {
        return TrustType.fromValue(this.trustType);
    }

    public String trustTypeAsString() {
        return this.trustType;
    }

    public boolean hasConditionalForwarderIpAddrs() {
        return this.conditionalForwarderIpAddrs != null && !(this.conditionalForwarderIpAddrs instanceof SdkAutoConstructList);
    }

    public List<String> conditionalForwarderIpAddrs() {
        return this.conditionalForwarderIpAddrs;
    }

    public SelectiveAuth selectiveAuth() {
        return SelectiveAuth.fromValue(this.selectiveAuth);
    }

    public String selectiveAuthAsString() {
        return this.selectiveAuth;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.remoteDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustPassword());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustDirectionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.trustTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.conditionalForwarderIpAddrs());
        hashCode = 31 * hashCode + Objects.hashCode(this.selectiveAuthAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrustRequest)) {
            return false;
        }
        CreateTrustRequest other = (CreateTrustRequest)((Object)obj);
        return Objects.equals(this.directoryId(), other.directoryId()) && Objects.equals(this.remoteDomainName(), other.remoteDomainName()) && Objects.equals(this.trustPassword(), other.trustPassword()) && Objects.equals(this.trustDirectionAsString(), other.trustDirectionAsString()) && Objects.equals(this.trustTypeAsString(), other.trustTypeAsString()) && Objects.equals(this.conditionalForwarderIpAddrs(), other.conditionalForwarderIpAddrs()) && Objects.equals(this.selectiveAuthAsString(), other.selectiveAuthAsString());
    }

    public String toString() {
        return ToString.builder((String)"CreateTrustRequest").add("DirectoryId", (Object)this.directoryId()).add("RemoteDomainName", (Object)this.remoteDomainName()).add("TrustPassword", (Object)(this.trustPassword() == null ? null : "*** Sensitive Data Redacted ***")).add("TrustDirection", (Object)this.trustDirectionAsString()).add("TrustType", (Object)this.trustTypeAsString()).add("ConditionalForwarderIpAddrs", this.conditionalForwarderIpAddrs()).add("SelectiveAuth", (Object)this.selectiveAuthAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DirectoryId": {
                return Optional.ofNullable(clazz.cast(this.directoryId()));
            }
            case "RemoteDomainName": {
                return Optional.ofNullable(clazz.cast(this.remoteDomainName()));
            }
            case "TrustPassword": {
                return Optional.ofNullable(clazz.cast(this.trustPassword()));
            }
            case "TrustDirection": {
                return Optional.ofNullable(clazz.cast(this.trustDirectionAsString()));
            }
            case "TrustType": {
                return Optional.ofNullable(clazz.cast(this.trustTypeAsString()));
            }
            case "ConditionalForwarderIpAddrs": {
                return Optional.ofNullable(clazz.cast(this.conditionalForwarderIpAddrs()));
            }
            case "SelectiveAuth": {
                return Optional.ofNullable(clazz.cast(this.selectiveAuthAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrustRequest, T> g) {
        return obj -> g.apply((CreateTrustRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectoryRequest.BuilderImpl
    implements Builder {
        private String directoryId;
        private String remoteDomainName;
        private String trustPassword;
        private String trustDirection;
        private String trustType;
        private List<String> conditionalForwarderIpAddrs = DefaultSdkAutoConstructList.getInstance();
        private String selectiveAuth;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrustRequest model) {
            super(model);
            this.directoryId(model.directoryId);
            this.remoteDomainName(model.remoteDomainName);
            this.trustPassword(model.trustPassword);
            this.trustDirection(model.trustDirection);
            this.trustType(model.trustType);
            this.conditionalForwarderIpAddrs(model.conditionalForwarderIpAddrs);
            this.selectiveAuth(model.selectiveAuth);
        }

        public final String getDirectoryId() {
            return this.directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getRemoteDomainName() {
            return this.remoteDomainName;
        }

        @Override
        public final Builder remoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
            return this;
        }

        public final void setRemoteDomainName(String remoteDomainName) {
            this.remoteDomainName = remoteDomainName;
        }

        public final String getTrustPassword() {
            return this.trustPassword;
        }

        @Override
        public final Builder trustPassword(String trustPassword) {
            this.trustPassword = trustPassword;
            return this;
        }

        public final void setTrustPassword(String trustPassword) {
            this.trustPassword = trustPassword;
        }

        public final String getTrustDirection() {
            return this.trustDirection;
        }

        @Override
        public final Builder trustDirection(String trustDirection) {
            this.trustDirection = trustDirection;
            return this;
        }

        @Override
        public final Builder trustDirection(TrustDirection trustDirection) {
            this.trustDirection(trustDirection == null ? null : trustDirection.toString());
            return this;
        }

        public final void setTrustDirection(String trustDirection) {
            this.trustDirection = trustDirection;
        }

        public final String getTrustType() {
            return this.trustType;
        }

        @Override
        public final Builder trustType(String trustType) {
            this.trustType = trustType;
            return this;
        }

        @Override
        public final Builder trustType(TrustType trustType) {
            this.trustType(trustType == null ? null : trustType.toString());
            return this;
        }

        public final void setTrustType(String trustType) {
            this.trustType = trustType;
        }

        public final Collection<String> getConditionalForwarderIpAddrs() {
            return this.conditionalForwarderIpAddrs;
        }

        @Override
        public final Builder conditionalForwarderIpAddrs(Collection<String> conditionalForwarderIpAddrs) {
            this.conditionalForwarderIpAddrs = DnsIpAddrsCopier.copy(conditionalForwarderIpAddrs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditionalForwarderIpAddrs(String ... conditionalForwarderIpAddrs) {
            this.conditionalForwarderIpAddrs(Arrays.asList(conditionalForwarderIpAddrs));
            return this;
        }

        public final void setConditionalForwarderIpAddrs(Collection<String> conditionalForwarderIpAddrs) {
            this.conditionalForwarderIpAddrs = DnsIpAddrsCopier.copy(conditionalForwarderIpAddrs);
        }

        public final String getSelectiveAuth() {
            return this.selectiveAuth;
        }

        @Override
        public final Builder selectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
            return this;
        }

        @Override
        public final Builder selectiveAuth(SelectiveAuth selectiveAuth) {
            this.selectiveAuth(selectiveAuth == null ? null : selectiveAuth.toString());
            return this;
        }

        public final void setSelectiveAuth(String selectiveAuth) {
            this.selectiveAuth = selectiveAuth;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrustRequest build() {
            return new CreateTrustRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectoryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrustRequest> {
        public Builder directoryId(String var1);

        public Builder remoteDomainName(String var1);

        public Builder trustPassword(String var1);

        public Builder trustDirection(String var1);

        public Builder trustDirection(TrustDirection var1);

        public Builder trustType(String var1);

        public Builder trustType(TrustType var1);

        public Builder conditionalForwarderIpAddrs(Collection<String> var1);

        public Builder conditionalForwarderIpAddrs(String ... var1);

        public Builder selectiveAuth(String var1);

        public Builder selectiveAuth(SelectiveAuth var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

