/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a log subscription, which tracks real-time data from a chosen log group to a specified destination.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LogSubscription implements SdkPojo, Serializable, ToCopyableBuilder<LogSubscription.Builder, LogSubscription> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LogSubscription::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(LogSubscription::logGroupName)).setter(setter(Builder::logGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogGroupName").build()).build();

    private static final SdkField<Instant> SUBSCRIPTION_CREATED_DATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(LogSubscription::subscriptionCreatedDateTime))
            .setter(setter(Builder::subscriptionCreatedDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionCreatedDateTime")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            LOG_GROUP_NAME_FIELD, SUBSCRIPTION_CREATED_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String directoryId;

    private final String logGroupName;

    private final Instant subscriptionCreatedDateTime;

    private LogSubscription(BuilderImpl builder) {
        this.directoryId = builder.directoryId;
        this.logGroupName = builder.logGroupName;
        this.subscriptionCreatedDateTime = builder.subscriptionCreatedDateTime;
    }

    /**
     * <p>
     * Identifier (ID) of the directory that you want to associate with the log subscription.
     * </p>
     * 
     * @return Identifier (ID) of the directory that you want to associate with the log subscription.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * The name of the log group.
     * </p>
     * 
     * @return The name of the log group.
     */
    public String logGroupName() {
        return logGroupName;
    }

    /**
     * <p>
     * The date and time that the log subscription was created.
     * </p>
     * 
     * @return The date and time that the log subscription was created.
     */
    public Instant subscriptionCreatedDateTime() {
        return subscriptionCreatedDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(logGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionCreatedDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogSubscription)) {
            return false;
        }
        LogSubscription other = (LogSubscription) obj;
        return Objects.equals(directoryId(), other.directoryId()) && Objects.equals(logGroupName(), other.logGroupName())
                && Objects.equals(subscriptionCreatedDateTime(), other.subscriptionCreatedDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("LogSubscription").add("DirectoryId", directoryId()).add("LogGroupName", logGroupName())
                .add("SubscriptionCreatedDateTime", subscriptionCreatedDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "LogGroupName":
            return Optional.ofNullable(clazz.cast(logGroupName()));
        case "SubscriptionCreatedDateTime":
            return Optional.ofNullable(clazz.cast(subscriptionCreatedDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogSubscription, T> g) {
        return obj -> g.apply((LogSubscription) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LogSubscription> {
        /**
         * <p>
         * Identifier (ID) of the directory that you want to associate with the log subscription.
         * </p>
         * 
         * @param directoryId
         *        Identifier (ID) of the directory that you want to associate with the log subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The name of the log group.
         * </p>
         * 
         * @param logGroupName
         *        The name of the log group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logGroupName(String logGroupName);

        /**
         * <p>
         * The date and time that the log subscription was created.
         * </p>
         * 
         * @param subscriptionCreatedDateTime
         *        The date and time that the log subscription was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionCreatedDateTime(Instant subscriptionCreatedDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String directoryId;

        private String logGroupName;

        private Instant subscriptionCreatedDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(LogSubscription model) {
            directoryId(model.directoryId);
            logGroupName(model.logGroupName);
            subscriptionCreatedDateTime(model.subscriptionCreatedDateTime);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final String getLogGroupName() {
            return logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        public final Instant getSubscriptionCreatedDateTime() {
            return subscriptionCreatedDateTime;
        }

        @Override
        public final Builder subscriptionCreatedDateTime(Instant subscriptionCreatedDateTime) {
            this.subscriptionCreatedDateTime = subscriptionCreatedDateTime;
            return this;
        }

        public final void setSubscriptionCreatedDateTime(Instant subscriptionCreatedDateTime) {
            this.subscriptionCreatedDateTime = subscriptionCreatedDateTime;
        }

        @Override
        public LogSubscription build() {
            return new LogSubscription(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
