/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSchemaExtensionRequest extends DirectoryRequest implements
        ToCopyableBuilder<StartSchemaExtensionRequest.Builder, StartSchemaExtensionRequest> {
    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartSchemaExtensionRequest::directoryId)).setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<Boolean> CREATE_SNAPSHOT_BEFORE_SCHEMA_EXTENSION_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(StartSchemaExtensionRequest::createSnapshotBeforeSchemaExtension))
            .setter(setter(Builder::createSnapshotBeforeSchemaExtension))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CreateSnapshotBeforeSchemaExtension").build()).build();

    private static final SdkField<String> LDIF_CONTENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartSchemaExtensionRequest::ldifContent)).setter(setter(Builder::ldifContent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LdifContent").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(StartSchemaExtensionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_ID_FIELD,
            CREATE_SNAPSHOT_BEFORE_SCHEMA_EXTENSION_FIELD, LDIF_CONTENT_FIELD, DESCRIPTION_FIELD));

    private final String directoryId;

    private final Boolean createSnapshotBeforeSchemaExtension;

    private final String ldifContent;

    private final String description;

    private StartSchemaExtensionRequest(BuilderImpl builder) {
        super(builder);
        this.directoryId = builder.directoryId;
        this.createSnapshotBeforeSchemaExtension = builder.createSnapshotBeforeSchemaExtension;
        this.ldifContent = builder.ldifContent;
        this.description = builder.description;
    }

    /**
     * <p>
     * The identifier of the directory for which the schema extension will be applied to.
     * </p>
     * 
     * @return The identifier of the directory for which the schema extension will be applied to.
     */
    public String directoryId() {
        return directoryId;
    }

    /**
     * <p>
     * If true, creates a snapshot of the directory before applying the schema extension.
     * </p>
     * 
     * @return If true, creates a snapshot of the directory before applying the schema extension.
     */
    public Boolean createSnapshotBeforeSchemaExtension() {
        return createSnapshotBeforeSchemaExtension;
    }

    /**
     * <p>
     * The LDIF file represented as a string. To construct the LdifContent string, precede each line as it would be
     * formatted in an ldif file with \n. See the example request below for more details. The file size can be no larger
     * than 1MB.
     * </p>
     * 
     * @return The LDIF file represented as a string. To construct the LdifContent string, precede each line as it would
     *         be formatted in an ldif file with \n. See the example request below for more details. The file size can
     *         be no larger than 1MB.
     */
    public String ldifContent() {
        return ldifContent;
    }

    /**
     * <p>
     * A description of the schema extension.
     * </p>
     * 
     * @return A description of the schema extension.
     */
    public String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(createSnapshotBeforeSchemaExtension());
        hashCode = 31 * hashCode + Objects.hashCode(ldifContent());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSchemaExtensionRequest)) {
            return false;
        }
        StartSchemaExtensionRequest other = (StartSchemaExtensionRequest) obj;
        return Objects.equals(directoryId(), other.directoryId())
                && Objects.equals(createSnapshotBeforeSchemaExtension(), other.createSnapshotBeforeSchemaExtension())
                && Objects.equals(ldifContent(), other.ldifContent()) && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("StartSchemaExtensionRequest").add("DirectoryId", directoryId())
                .add("CreateSnapshotBeforeSchemaExtension", createSnapshotBeforeSchemaExtension())
                .add("LdifContent", ldifContent()).add("Description", description()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "CreateSnapshotBeforeSchemaExtension":
            return Optional.ofNullable(clazz.cast(createSnapshotBeforeSchemaExtension()));
        case "LdifContent":
            return Optional.ofNullable(clazz.cast(ldifContent()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartSchemaExtensionRequest, T> g) {
        return obj -> g.apply((StartSchemaExtensionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectoryRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartSchemaExtensionRequest> {
        /**
         * <p>
         * The identifier of the directory for which the schema extension will be applied to.
         * </p>
         * 
         * @param directoryId
         *        The identifier of the directory for which the schema extension will be applied to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * If true, creates a snapshot of the directory before applying the schema extension.
         * </p>
         * 
         * @param createSnapshotBeforeSchemaExtension
         *        If true, creates a snapshot of the directory before applying the schema extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createSnapshotBeforeSchemaExtension(Boolean createSnapshotBeforeSchemaExtension);

        /**
         * <p>
         * The LDIF file represented as a string. To construct the LdifContent string, precede each line as it would be
         * formatted in an ldif file with \n. See the example request below for more details. The file size can be no
         * larger than 1MB.
         * </p>
         * 
         * @param ldifContent
         *        The LDIF file represented as a string. To construct the LdifContent string, precede each line as it
         *        would be formatted in an ldif file with \n. See the example request below for more details. The file
         *        size can be no larger than 1MB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ldifContent(String ldifContent);

        /**
         * <p>
         * A description of the schema extension.
         * </p>
         * 
         * @param description
         *        A description of the schema extension.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectoryRequest.BuilderImpl implements Builder {
        private String directoryId;

        private Boolean createSnapshotBeforeSchemaExtension;

        private String ldifContent;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(StartSchemaExtensionRequest model) {
            super(model);
            directoryId(model.directoryId);
            createSnapshotBeforeSchemaExtension(model.createSnapshotBeforeSchemaExtension);
            ldifContent(model.ldifContent);
            description(model.description);
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public final Boolean getCreateSnapshotBeforeSchemaExtension() {
            return createSnapshotBeforeSchemaExtension;
        }

        @Override
        public final Builder createSnapshotBeforeSchemaExtension(Boolean createSnapshotBeforeSchemaExtension) {
            this.createSnapshotBeforeSchemaExtension = createSnapshotBeforeSchemaExtension;
            return this;
        }

        public final void setCreateSnapshotBeforeSchemaExtension(Boolean createSnapshotBeforeSchemaExtension) {
            this.createSnapshotBeforeSchemaExtension = createSnapshotBeforeSchemaExtension;
        }

        public final String getLdifContent() {
            return ldifContent;
        }

        @Override
        public final Builder ldifContent(String ldifContent) {
            this.ldifContent = ldifContent;
            return this;
        }

        public final void setLdifContent(String ldifContent) {
            this.ldifContent = ldifContent;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSchemaExtensionRequest build() {
            return new StartSchemaExtensionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
