/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information for the <a>ConnectDirectory</a> operation when an AD Connector directory is being created.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectoryConnectSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectoryConnectSettings.Builder, DirectoryConnectSettings> {
    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DirectoryConnectSettings::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()).build();

    private static final SdkField<List<String>> SUBNET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DirectoryConnectSettings::subnetIds))
            .setter(setter(Builder::subnetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CUSTOMER_DNS_IPS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DirectoryConnectSettings::customerDnsIps))
            .setter(setter(Builder::customerDnsIps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerDnsIps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CUSTOMER_USER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DirectoryConnectSettings::customerUserName)).setter(setter(Builder::customerUserName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerUserName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ID_FIELD,
            SUBNET_IDS_FIELD, CUSTOMER_DNS_IPS_FIELD, CUSTOMER_USER_NAME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String vpcId;

    private final List<String> subnetIds;

    private final List<String> customerDnsIps;

    private final String customerUserName;

    private DirectoryConnectSettings(BuilderImpl builder) {
        this.vpcId = builder.vpcId;
        this.subnetIds = builder.subnetIds;
        this.customerDnsIps = builder.customerDnsIps;
        this.customerUserName = builder.customerUserName;
    }

    /**
     * <p>
     * The identifier of the VPC in which the AD Connector is created.
     * </p>
     * 
     * @return The identifier of the VPC in which the AD Connector is created.
     */
    public String vpcId() {
        return vpcId;
    }

    /**
     * Returns true if the SubnetIds property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSubnetIds() {
        return subnetIds != null && !(subnetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of subnet identifiers in the VPC in which the AD Connector is created.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSubnetIds()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of subnet identifiers in the VPC in which the AD Connector is created.
     */
    public List<String> subnetIds() {
        return subnetIds;
    }

    /**
     * Returns true if the CustomerDnsIps property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasCustomerDnsIps() {
        return customerDnsIps != null && !(customerDnsIps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of one or more IP addresses of DNS servers or domain controllers in the on-premises directory.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCustomerDnsIps()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of one or more IP addresses of DNS servers or domain controllers in the on-premises directory.
     */
    public List<String> customerDnsIps() {
        return customerDnsIps;
    }

    /**
     * <p>
     * The user name of an account in the on-premises directory that is used to connect to the directory. This account
     * must have the following permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Read users and groups
     * </p>
     * </li>
     * <li>
     * <p>
     * Create computer objects
     * </p>
     * </li>
     * <li>
     * <p>
     * Join computers to the domain
     * </p>
     * </li>
     * </ul>
     * 
     * @return The user name of an account in the on-premises directory that is used to connect to the directory. This
     *         account must have the following permissions:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Read users and groups
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Create computer objects
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Join computers to the domain
     *         </p>
     *         </li>
     */
    public String customerUserName() {
        return customerUserName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(subnetIds());
        hashCode = 31 * hashCode + Objects.hashCode(customerDnsIps());
        hashCode = 31 * hashCode + Objects.hashCode(customerUserName());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConnectSettings)) {
            return false;
        }
        DirectoryConnectSettings other = (DirectoryConnectSettings) obj;
        return Objects.equals(vpcId(), other.vpcId()) && Objects.equals(subnetIds(), other.subnetIds())
                && Objects.equals(customerDnsIps(), other.customerDnsIps())
                && Objects.equals(customerUserName(), other.customerUserName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DirectoryConnectSettings").add("VpcId", vpcId()).add("SubnetIds", subnetIds())
                .add("CustomerDnsIps", customerDnsIps()).add("CustomerUserName", customerUserName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        case "SubnetIds":
            return Optional.ofNullable(clazz.cast(subnetIds()));
        case "CustomerDnsIps":
            return Optional.ofNullable(clazz.cast(customerDnsIps()));
        case "CustomerUserName":
            return Optional.ofNullable(clazz.cast(customerUserName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectoryConnectSettings, T> g) {
        return obj -> g.apply((DirectoryConnectSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectoryConnectSettings> {
        /**
         * <p>
         * The identifier of the VPC in which the AD Connector is created.
         * </p>
         * 
         * @param vpcId
         *        The identifier of the VPC in which the AD Connector is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);

        /**
         * <p>
         * A list of subnet identifiers in the VPC in which the AD Connector is created.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet identifiers in the VPC in which the AD Connector is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(Collection<String> subnetIds);

        /**
         * <p>
         * A list of subnet identifiers in the VPC in which the AD Connector is created.
         * </p>
         * 
         * @param subnetIds
         *        A list of subnet identifiers in the VPC in which the AD Connector is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetIds(String... subnetIds);

        /**
         * <p>
         * A list of one or more IP addresses of DNS servers or domain controllers in the on-premises directory.
         * </p>
         * 
         * @param customerDnsIps
         *        A list of one or more IP addresses of DNS servers or domain controllers in the on-premises directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerDnsIps(Collection<String> customerDnsIps);

        /**
         * <p>
         * A list of one or more IP addresses of DNS servers or domain controllers in the on-premises directory.
         * </p>
         * 
         * @param customerDnsIps
         *        A list of one or more IP addresses of DNS servers or domain controllers in the on-premises directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerDnsIps(String... customerDnsIps);

        /**
         * <p>
         * The user name of an account in the on-premises directory that is used to connect to the directory. This
         * account must have the following permissions:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Read users and groups
         * </p>
         * </li>
         * <li>
         * <p>
         * Create computer objects
         * </p>
         * </li>
         * <li>
         * <p>
         * Join computers to the domain
         * </p>
         * </li>
         * </ul>
         * 
         * @param customerUserName
         *        The user name of an account in the on-premises directory that is used to connect to the directory.
         *        This account must have the following permissions:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Read users and groups
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Create computer objects
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Join computers to the domain
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerUserName(String customerUserName);
    }

    static final class BuilderImpl implements Builder {
        private String vpcId;

        private List<String> subnetIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> customerDnsIps = DefaultSdkAutoConstructList.getInstance();

        private String customerUserName;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryConnectSettings model) {
            vpcId(model.vpcId);
            subnetIds(model.subnetIds);
            customerDnsIps(model.customerDnsIps);
            customerUserName(model.customerUserName);
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        public final Collection<String> getSubnetIds() {
            return subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String... subnetIds) {
            subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdsCopier.copy(subnetIds);
        }

        public final Collection<String> getCustomerDnsIps() {
            return customerDnsIps;
        }

        @Override
        public final Builder customerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = DnsIpAddrsCopier.copy(customerDnsIps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerDnsIps(String... customerDnsIps) {
            customerDnsIps(Arrays.asList(customerDnsIps));
            return this;
        }

        public final void setCustomerDnsIps(Collection<String> customerDnsIps) {
            this.customerDnsIps = DnsIpAddrsCopier.copy(customerDnsIps);
        }

        public final String getCustomerUserName() {
            return customerUserName;
        }

        @Override
        public final Builder customerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
            return this;
        }

        public final void setCustomerUserName(String customerUserName) {
            this.customerUserName = customerUserName;
        }

        @Override
        public DirectoryConnectSettings build() {
            return new DirectoryConnectSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
