/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directory.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the certificate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Certificate implements SdkPojo, Serializable, ToCopyableBuilder<Certificate.Builder, Certificate> {
    private static final SdkField<String> CERTIFICATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Certificate::certificateId)).setter(setter(Builder::certificateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Certificate::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> STATE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Certificate::stateReason)).setter(setter(Builder::stateReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateReason").build()).build();

    private static final SdkField<String> COMMON_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Certificate::commonName)).setter(setter(Builder::commonName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommonName").build()).build();

    private static final SdkField<Instant> REGISTERED_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Certificate::registeredDateTime)).setter(setter(Builder::registeredDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegisteredDateTime").build())
            .build();

    private static final SdkField<Instant> EXPIRY_DATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Certificate::expiryDateTime)).setter(setter(Builder::expiryDateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpiryDateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CERTIFICATE_ID_FIELD,
            STATE_FIELD, STATE_REASON_FIELD, COMMON_NAME_FIELD, REGISTERED_DATE_TIME_FIELD, EXPIRY_DATE_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String certificateId;

    private final String state;

    private final String stateReason;

    private final String commonName;

    private final Instant registeredDateTime;

    private final Instant expiryDateTime;

    private Certificate(BuilderImpl builder) {
        this.certificateId = builder.certificateId;
        this.state = builder.state;
        this.stateReason = builder.stateReason;
        this.commonName = builder.commonName;
        this.registeredDateTime = builder.registeredDateTime;
        this.expiryDateTime = builder.expiryDateTime;
    }

    /**
     * <p>
     * The identifier of the certificate.
     * </p>
     * 
     * @return The identifier of the certificate.
     */
    public String certificateId() {
        return certificateId;
    }

    /**
     * <p>
     * The state of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CertificateState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the certificate.
     * @see CertificateState
     */
    public CertificateState state() {
        return CertificateState.fromValue(state);
    }

    /**
     * <p>
     * The state of the certificate.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link CertificateState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the certificate.
     * @see CertificateState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Describes a state change for the certificate.
     * </p>
     * 
     * @return Describes a state change for the certificate.
     */
    public String stateReason() {
        return stateReason;
    }

    /**
     * <p>
     * The common name for the certificate.
     * </p>
     * 
     * @return The common name for the certificate.
     */
    public String commonName() {
        return commonName;
    }

    /**
     * <p>
     * The date and time that the certificate was registered.
     * </p>
     * 
     * @return The date and time that the certificate was registered.
     */
    public Instant registeredDateTime() {
        return registeredDateTime;
    }

    /**
     * <p>
     * The date and time when the certificate will expire.
     * </p>
     * 
     * @return The date and time when the certificate will expire.
     */
    public Instant expiryDateTime() {
        return expiryDateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(certificateId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateReason());
        hashCode = 31 * hashCode + Objects.hashCode(commonName());
        hashCode = 31 * hashCode + Objects.hashCode(registeredDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(expiryDateTime());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Certificate)) {
            return false;
        }
        Certificate other = (Certificate) obj;
        return Objects.equals(certificateId(), other.certificateId()) && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(stateReason(), other.stateReason()) && Objects.equals(commonName(), other.commonName())
                && Objects.equals(registeredDateTime(), other.registeredDateTime())
                && Objects.equals(expiryDateTime(), other.expiryDateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Certificate").add("CertificateId", certificateId()).add("State", stateAsString())
                .add("StateReason", stateReason()).add("CommonName", commonName())
                .add("RegisteredDateTime", registeredDateTime()).add("ExpiryDateTime", expiryDateTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CertificateId":
            return Optional.ofNullable(clazz.cast(certificateId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "StateReason":
            return Optional.ofNullable(clazz.cast(stateReason()));
        case "CommonName":
            return Optional.ofNullable(clazz.cast(commonName()));
        case "RegisteredDateTime":
            return Optional.ofNullable(clazz.cast(registeredDateTime()));
        case "ExpiryDateTime":
            return Optional.ofNullable(clazz.cast(expiryDateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Certificate, T> g) {
        return obj -> g.apply((Certificate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Certificate> {
        /**
         * <p>
         * The identifier of the certificate.
         * </p>
         * 
         * @param certificateId
         *        The identifier of the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateId(String certificateId);

        /**
         * <p>
         * The state of the certificate.
         * </p>
         * 
         * @param state
         *        The state of the certificate.
         * @see CertificateState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the certificate.
         * </p>
         * 
         * @param state
         *        The state of the certificate.
         * @see CertificateState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CertificateState
         */
        Builder state(CertificateState state);

        /**
         * <p>
         * Describes a state change for the certificate.
         * </p>
         * 
         * @param stateReason
         *        Describes a state change for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateReason(String stateReason);

        /**
         * <p>
         * The common name for the certificate.
         * </p>
         * 
         * @param commonName
         *        The common name for the certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commonName(String commonName);

        /**
         * <p>
         * The date and time that the certificate was registered.
         * </p>
         * 
         * @param registeredDateTime
         *        The date and time that the certificate was registered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registeredDateTime(Instant registeredDateTime);

        /**
         * <p>
         * The date and time when the certificate will expire.
         * </p>
         * 
         * @param expiryDateTime
         *        The date and time when the certificate will expire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiryDateTime(Instant expiryDateTime);
    }

    static final class BuilderImpl implements Builder {
        private String certificateId;

        private String state;

        private String stateReason;

        private String commonName;

        private Instant registeredDateTime;

        private Instant expiryDateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Certificate model) {
            certificateId(model.certificateId);
            state(model.state);
            stateReason(model.stateReason);
            commonName(model.commonName);
            registeredDateTime(model.registeredDateTime);
            expiryDateTime(model.expiryDateTime);
        }

        public final String getCertificateId() {
            return certificateId;
        }

        @Override
        public final Builder certificateId(String certificateId) {
            this.certificateId = certificateId;
            return this;
        }

        public final void setCertificateId(String certificateId) {
            this.certificateId = certificateId;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CertificateState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getStateReason() {
            return stateReason;
        }

        @Override
        public final Builder stateReason(String stateReason) {
            this.stateReason = stateReason;
            return this;
        }

        public final void setStateReason(String stateReason) {
            this.stateReason = stateReason;
        }

        public final String getCommonName() {
            return commonName;
        }

        @Override
        public final Builder commonName(String commonName) {
            this.commonName = commonName;
            return this;
        }

        public final void setCommonName(String commonName) {
            this.commonName = commonName;
        }

        public final Instant getRegisteredDateTime() {
            return registeredDateTime;
        }

        @Override
        public final Builder registeredDateTime(Instant registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
            return this;
        }

        public final void setRegisteredDateTime(Instant registeredDateTime) {
            this.registeredDateTime = registeredDateTime;
        }

        public final Instant getExpiryDateTime() {
            return expiryDateTime;
        }

        @Override
        public final Builder expiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
            return this;
        }

        public final void setExpiryDateTime(Instant expiryDateTime) {
            this.expiryDateTime = expiryDateTime;
        }

        @Override
        public Certificate build() {
            return new Certificate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
