/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewPrivateVirtualInterface;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePrivateVirtualInterfaceRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreatePrivateVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreatePrivateVirtualInterfaceRequest.getter(CreatePrivateVirtualInterfaceRequest::connectionId)).setter(CreatePrivateVirtualInterfaceRequest.setter(Builder::connectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()}).build();
    private static final SdkField<NewPrivateVirtualInterface> NEW_PRIVATE_VIRTUAL_INTERFACE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreatePrivateVirtualInterfaceRequest.getter(CreatePrivateVirtualInterfaceRequest::newPrivateVirtualInterface)).setter(CreatePrivateVirtualInterfaceRequest.setter(Builder::newPrivateVirtualInterface)).constructor(NewPrivateVirtualInterface::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newPrivateVirtualInterface").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD, NEW_PRIVATE_VIRTUAL_INTERFACE_FIELD));
    private final String connectionId;
    private final NewPrivateVirtualInterface newPrivateVirtualInterface;

    private CreatePrivateVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.newPrivateVirtualInterface = builder.newPrivateVirtualInterface;
    }

    public String connectionId() {
        return this.connectionId;
    }

    public NewPrivateVirtualInterface newPrivateVirtualInterface() {
        return this.newPrivateVirtualInterface;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newPrivateVirtualInterface());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePrivateVirtualInterfaceRequest)) {
            return false;
        }
        CreatePrivateVirtualInterfaceRequest other = (CreatePrivateVirtualInterfaceRequest)((Object)obj);
        return Objects.equals(this.connectionId(), other.connectionId()) && Objects.equals(this.newPrivateVirtualInterface(), other.newPrivateVirtualInterface());
    }

    public String toString() {
        return ToString.builder((String)"CreatePrivateVirtualInterfaceRequest").add("ConnectionId", (Object)this.connectionId()).add("NewPrivateVirtualInterface", (Object)this.newPrivateVirtualInterface()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionId": {
                return Optional.ofNullable(clazz.cast(this.connectionId()));
            }
            case "newPrivateVirtualInterface": {
                return Optional.ofNullable(clazz.cast(this.newPrivateVirtualInterface()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreatePrivateVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((CreatePrivateVirtualInterfaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String connectionId;
        private NewPrivateVirtualInterface newPrivateVirtualInterface;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePrivateVirtualInterfaceRequest model) {
            super(model);
            this.connectionId(model.connectionId);
            this.newPrivateVirtualInterface(model.newPrivateVirtualInterface);
        }

        public final String getConnectionId() {
            return this.connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final NewPrivateVirtualInterface.Builder getNewPrivateVirtualInterface() {
            return this.newPrivateVirtualInterface != null ? this.newPrivateVirtualInterface.toBuilder() : null;
        }

        @Override
        public final Builder newPrivateVirtualInterface(NewPrivateVirtualInterface newPrivateVirtualInterface) {
            this.newPrivateVirtualInterface = newPrivateVirtualInterface;
            return this;
        }

        public final void setNewPrivateVirtualInterface(NewPrivateVirtualInterface.BuilderImpl newPrivateVirtualInterface) {
            this.newPrivateVirtualInterface = newPrivateVirtualInterface != null ? newPrivateVirtualInterface.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePrivateVirtualInterfaceRequest build() {
            return new CreatePrivateVirtualInterfaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePrivateVirtualInterfaceRequest> {
        public Builder connectionId(String var1);

        public Builder newPrivateVirtualInterface(NewPrivateVirtualInterface var1);

        default public Builder newPrivateVirtualInterface(Consumer<NewPrivateVirtualInterface.Builder> newPrivateVirtualInterface) {
            return this.newPrivateVirtualInterface((NewPrivateVirtualInterface)((NewPrivateVirtualInterface.Builder)NewPrivateVirtualInterface.builder().applyMutation(newPrivateVirtualInterface)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

