/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.GatewayType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociatedGateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssociatedGateway> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociatedGateway.getter(AssociatedGateway::id)).setter(AssociatedGateway.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociatedGateway.getter(AssociatedGateway::typeAsString)).setter(AssociatedGateway.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociatedGateway.getter(AssociatedGateway::ownerAccount)).setter(AssociatedGateway.setter(Builder::ownerAccount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(AssociatedGateway.getter(AssociatedGateway::region)).setter(AssociatedGateway.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD, OWNER_ACCOUNT_FIELD, REGION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String type;
    private final String ownerAccount;
    private final String region;

    private AssociatedGateway(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.ownerAccount = builder.ownerAccount;
        this.region = builder.region;
    }

    public String id() {
        return this.id;
    }

    public GatewayType type() {
        return GatewayType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public String ownerAccount() {
        return this.ownerAccount;
    }

    public String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociatedGateway)) {
            return false;
        }
        AssociatedGateway other = (AssociatedGateway)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.ownerAccount(), other.ownerAccount()) && Objects.equals(this.region(), other.region());
    }

    public String toString() {
        return ToString.builder((String)"AssociatedGateway").add("Id", (Object)this.id()).add("Type", (Object)this.typeAsString()).add("OwnerAccount", (Object)this.ownerAccount()).add("Region", (Object)this.region()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "ownerAccount": {
                return Optional.ofNullable(clazz.cast(this.ownerAccount()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociatedGateway, T> g) {
        return obj -> g.apply((AssociatedGateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String type;
        private String ownerAccount;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociatedGateway model) {
            this.id(model.id);
            this.type(model.type);
            this.ownerAccount(model.ownerAccount);
            this.region(model.region);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getTypeAsString() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getOwnerAccount() {
            return this.ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public AssociatedGateway build() {
            return new AssociatedGateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssociatedGateway> {
        public Builder id(String var1);

        public Builder type(String var1);

        public Builder type(GatewayType var1);

        public Builder ownerAccount(String var1);

        public Builder region(String var1);
    }
}

