/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.HasLogicalRedundancy;
import software.amazon.awssdk.services.directconnect.model.InterconnectState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Interconnect
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Interconnect> {
    private static final SdkField<String> INTERCONNECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::interconnectId)).setter(Interconnect.setter(Builder::interconnectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectId").build()}).build();
    private static final SdkField<String> INTERCONNECT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::interconnectName)).setter(Interconnect.setter(Builder::interconnectName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectName").build()}).build();
    private static final SdkField<String> INTERCONNECT_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::interconnectStateAsString)).setter(Interconnect.setter(Builder::interconnectState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interconnectState").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::region)).setter(Interconnect.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<String> LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::location)).setter(Interconnect.setter(Builder::location)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()}).build();
    private static final SdkField<String> BANDWIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::bandwidth)).setter(Interconnect.setter(Builder::bandwidth)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("bandwidth").build()}).build();
    private static final SdkField<Instant> LOA_ISSUE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Interconnect.getter(Interconnect::loaIssueTime)).setter(Interconnect.setter(Builder::loaIssueTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaIssueTime").build()}).build();
    private static final SdkField<String> LAG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::lagId)).setter(Interconnect.setter(Builder::lagId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagId").build()}).build();
    private static final SdkField<String> AWS_DEVICE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::awsDevice)).setter(Interconnect.setter(Builder::awsDevice)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDevice").build()}).build();
    private static final SdkField<Boolean> JUMBO_FRAME_CAPABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(Interconnect.getter(Interconnect::jumboFrameCapable)).setter(Interconnect.setter(Builder::jumboFrameCapable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jumboFrameCapable").build()}).build();
    private static final SdkField<String> AWS_DEVICE_V2_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::awsDeviceV2)).setter(Interconnect.setter(Builder::awsDeviceV2)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsDeviceV2").build()}).build();
    private static final SdkField<String> HAS_LOGICAL_REDUNDANCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Interconnect.getter(Interconnect::hasLogicalRedundancyAsString)).setter(Interconnect.setter(Builder::hasLogicalRedundancy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hasLogicalRedundancy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INTERCONNECT_ID_FIELD, INTERCONNECT_NAME_FIELD, INTERCONNECT_STATE_FIELD, REGION_FIELD, LOCATION_FIELD, BANDWIDTH_FIELD, LOA_ISSUE_TIME_FIELD, LAG_ID_FIELD, AWS_DEVICE_FIELD, JUMBO_FRAME_CAPABLE_FIELD, AWS_DEVICE_V2_FIELD, HAS_LOGICAL_REDUNDANCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String interconnectId;
    private final String interconnectName;
    private final String interconnectState;
    private final String region;
    private final String location;
    private final String bandwidth;
    private final Instant loaIssueTime;
    private final String lagId;
    private final String awsDevice;
    private final Boolean jumboFrameCapable;
    private final String awsDeviceV2;
    private final String hasLogicalRedundancy;

    private Interconnect(BuilderImpl builder) {
        this.interconnectId = builder.interconnectId;
        this.interconnectName = builder.interconnectName;
        this.interconnectState = builder.interconnectState;
        this.region = builder.region;
        this.location = builder.location;
        this.bandwidth = builder.bandwidth;
        this.loaIssueTime = builder.loaIssueTime;
        this.lagId = builder.lagId;
        this.awsDevice = builder.awsDevice;
        this.jumboFrameCapable = builder.jumboFrameCapable;
        this.awsDeviceV2 = builder.awsDeviceV2;
        this.hasLogicalRedundancy = builder.hasLogicalRedundancy;
    }

    public String interconnectId() {
        return this.interconnectId;
    }

    public String interconnectName() {
        return this.interconnectName;
    }

    public InterconnectState interconnectState() {
        return InterconnectState.fromValue(this.interconnectState);
    }

    public String interconnectStateAsString() {
        return this.interconnectState;
    }

    public String region() {
        return this.region;
    }

    public String location() {
        return this.location;
    }

    public String bandwidth() {
        return this.bandwidth;
    }

    public Instant loaIssueTime() {
        return this.loaIssueTime;
    }

    public String lagId() {
        return this.lagId;
    }

    public String awsDevice() {
        return this.awsDevice;
    }

    public Boolean jumboFrameCapable() {
        return this.jumboFrameCapable;
    }

    public String awsDeviceV2() {
        return this.awsDeviceV2;
    }

    public HasLogicalRedundancy hasLogicalRedundancy() {
        return HasLogicalRedundancy.fromValue(this.hasLogicalRedundancy);
    }

    public String hasLogicalRedundancyAsString() {
        return this.hasLogicalRedundancy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectName());
        hashCode = 31 * hashCode + Objects.hashCode(this.interconnectStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.location());
        hashCode = 31 * hashCode + Objects.hashCode(this.bandwidth());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaIssueTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lagId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDevice());
        hashCode = 31 * hashCode + Objects.hashCode(this.jumboFrameCapable());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsDeviceV2());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLogicalRedundancyAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Interconnect)) {
            return false;
        }
        Interconnect other = (Interconnect)obj;
        return Objects.equals(this.interconnectId(), other.interconnectId()) && Objects.equals(this.interconnectName(), other.interconnectName()) && Objects.equals(this.interconnectStateAsString(), other.interconnectStateAsString()) && Objects.equals(this.region(), other.region()) && Objects.equals(this.location(), other.location()) && Objects.equals(this.bandwidth(), other.bandwidth()) && Objects.equals(this.loaIssueTime(), other.loaIssueTime()) && Objects.equals(this.lagId(), other.lagId()) && Objects.equals(this.awsDevice(), other.awsDevice()) && Objects.equals(this.jumboFrameCapable(), other.jumboFrameCapable()) && Objects.equals(this.awsDeviceV2(), other.awsDeviceV2()) && Objects.equals(this.hasLogicalRedundancyAsString(), other.hasLogicalRedundancyAsString());
    }

    public String toString() {
        return ToString.builder((String)"Interconnect").add("InterconnectId", (Object)this.interconnectId()).add("InterconnectName", (Object)this.interconnectName()).add("InterconnectState", (Object)this.interconnectStateAsString()).add("Region", (Object)this.region()).add("Location", (Object)this.location()).add("Bandwidth", (Object)this.bandwidth()).add("LoaIssueTime", (Object)this.loaIssueTime()).add("LagId", (Object)this.lagId()).add("AwsDevice", (Object)this.awsDevice()).add("JumboFrameCapable", (Object)this.jumboFrameCapable()).add("AwsDeviceV2", (Object)this.awsDeviceV2()).add("HasLogicalRedundancy", (Object)this.hasLogicalRedundancyAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "interconnectId": {
                return Optional.ofNullable(clazz.cast(this.interconnectId()));
            }
            case "interconnectName": {
                return Optional.ofNullable(clazz.cast(this.interconnectName()));
            }
            case "interconnectState": {
                return Optional.ofNullable(clazz.cast(this.interconnectStateAsString()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "location": {
                return Optional.ofNullable(clazz.cast(this.location()));
            }
            case "bandwidth": {
                return Optional.ofNullable(clazz.cast(this.bandwidth()));
            }
            case "loaIssueTime": {
                return Optional.ofNullable(clazz.cast(this.loaIssueTime()));
            }
            case "lagId": {
                return Optional.ofNullable(clazz.cast(this.lagId()));
            }
            case "awsDevice": {
                return Optional.ofNullable(clazz.cast(this.awsDevice()));
            }
            case "jumboFrameCapable": {
                return Optional.ofNullable(clazz.cast(this.jumboFrameCapable()));
            }
            case "awsDeviceV2": {
                return Optional.ofNullable(clazz.cast(this.awsDeviceV2()));
            }
            case "hasLogicalRedundancy": {
                return Optional.ofNullable(clazz.cast(this.hasLogicalRedundancyAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Interconnect, T> g) {
        return obj -> g.apply((Interconnect)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String interconnectId;
        private String interconnectName;
        private String interconnectState;
        private String region;
        private String location;
        private String bandwidth;
        private Instant loaIssueTime;
        private String lagId;
        private String awsDevice;
        private Boolean jumboFrameCapable;
        private String awsDeviceV2;
        private String hasLogicalRedundancy;

        private BuilderImpl() {
        }

        private BuilderImpl(Interconnect model) {
            this.interconnectId(model.interconnectId);
            this.interconnectName(model.interconnectName);
            this.interconnectState(model.interconnectState);
            this.region(model.region);
            this.location(model.location);
            this.bandwidth(model.bandwidth);
            this.loaIssueTime(model.loaIssueTime);
            this.lagId(model.lagId);
            this.awsDevice(model.awsDevice);
            this.jumboFrameCapable(model.jumboFrameCapable);
            this.awsDeviceV2(model.awsDeviceV2);
            this.hasLogicalRedundancy(model.hasLogicalRedundancy);
        }

        public final String getInterconnectId() {
            return this.interconnectId;
        }

        @Override
        public final Builder interconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
            return this;
        }

        public final void setInterconnectId(String interconnectId) {
            this.interconnectId = interconnectId;
        }

        public final String getInterconnectName() {
            return this.interconnectName;
        }

        @Override
        public final Builder interconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
            return this;
        }

        public final void setInterconnectName(String interconnectName) {
            this.interconnectName = interconnectName;
        }

        public final String getInterconnectStateAsString() {
            return this.interconnectState;
        }

        @Override
        public final Builder interconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
            return this;
        }

        @Override
        public final Builder interconnectState(InterconnectState interconnectState) {
            this.interconnectState(interconnectState.toString());
            return this;
        }

        public final void setInterconnectState(String interconnectState) {
            this.interconnectState = interconnectState;
        }

        public final String getRegion() {
            return this.region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        public final String getLocation() {
            return this.location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        public final String getBandwidth() {
            return this.bandwidth;
        }

        @Override
        public final Builder bandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public final void setBandwidth(String bandwidth) {
            this.bandwidth = bandwidth;
        }

        public final Instant getLoaIssueTime() {
            return this.loaIssueTime;
        }

        @Override
        public final Builder loaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
            return this;
        }

        public final void setLoaIssueTime(Instant loaIssueTime) {
            this.loaIssueTime = loaIssueTime;
        }

        public final String getLagId() {
            return this.lagId;
        }

        @Override
        public final Builder lagId(String lagId) {
            this.lagId = lagId;
            return this;
        }

        public final void setLagId(String lagId) {
            this.lagId = lagId;
        }

        public final String getAwsDevice() {
            return this.awsDevice;
        }

        @Override
        public final Builder awsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
            return this;
        }

        public final void setAwsDevice(String awsDevice) {
            this.awsDevice = awsDevice;
        }

        public final Boolean getJumboFrameCapable() {
            return this.jumboFrameCapable;
        }

        @Override
        public final Builder jumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
            return this;
        }

        public final void setJumboFrameCapable(Boolean jumboFrameCapable) {
            this.jumboFrameCapable = jumboFrameCapable;
        }

        public final String getAwsDeviceV2() {
            return this.awsDeviceV2;
        }

        @Override
        public final Builder awsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
            return this;
        }

        public final void setAwsDeviceV2(String awsDeviceV2) {
            this.awsDeviceV2 = awsDeviceV2;
        }

        public final String getHasLogicalRedundancyAsString() {
            return this.hasLogicalRedundancy;
        }

        @Override
        public final Builder hasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
            return this;
        }

        @Override
        public final Builder hasLogicalRedundancy(HasLogicalRedundancy hasLogicalRedundancy) {
            this.hasLogicalRedundancy(hasLogicalRedundancy.toString());
            return this;
        }

        public final void setHasLogicalRedundancy(String hasLogicalRedundancy) {
            this.hasLogicalRedundancy = hasLogicalRedundancy;
        }

        public Interconnect build() {
            return new Interconnect(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Interconnect> {
        public Builder interconnectId(String var1);

        public Builder interconnectName(String var1);

        public Builder interconnectState(String var1);

        public Builder interconnectState(InterconnectState var1);

        public Builder region(String var1);

        public Builder location(String var1);

        public Builder bandwidth(String var1);

        public Builder loaIssueTime(Instant var1);

        public Builder lagId(String var1);

        public Builder awsDevice(String var1);

        public Builder jumboFrameCapable(Boolean var1);

        public Builder awsDeviceV2(String var1);

        public Builder hasLogicalRedundancy(String var1);

        public Builder hasLogicalRedundancy(HasLogicalRedundancy var1);
    }
}

