/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a virtual private gateway for a private virtual interface.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VirtualGateway implements SdkPojo, Serializable, ToCopyableBuilder<VirtualGateway.Builder, VirtualGateway> {
    private static final SdkField<String> VIRTUAL_GATEWAY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayId").getter(getter(VirtualGateway::virtualGatewayId))
            .setter(setter(Builder::virtualGatewayId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayId").build()).build();

    private static final SdkField<String> VIRTUAL_GATEWAY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("virtualGatewayState").getter(getter(VirtualGateway::virtualGatewayState))
            .setter(setter(Builder::virtualGatewayState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGatewayState").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_GATEWAY_ID_FIELD,
            VIRTUAL_GATEWAY_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String virtualGatewayId;

    private final String virtualGatewayState;

    private VirtualGateway(BuilderImpl builder) {
        this.virtualGatewayId = builder.virtualGatewayId;
        this.virtualGatewayState = builder.virtualGatewayState;
    }

    /**
     * <p>
     * The ID of the virtual private gateway.
     * </p>
     * 
     * @return The ID of the virtual private gateway.
     */
    public final String virtualGatewayId() {
        return virtualGatewayId;
    }

    /**
     * <p>
     * The state of the virtual private gateway. The following are the possible values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>pending</code>: Initial state after creating the virtual private gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>available</code>: Ready for use by a private virtual interface.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleting</code>: Initial state after deleting the virtual private gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>deleted</code>: The virtual private gateway is deleted. The private virtual interface is unable to send
     * traffic over this gateway.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The state of the virtual private gateway. The following are the possible values:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>pending</code>: Initial state after creating the virtual private gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>available</code>: Ready for use by a private virtual interface.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleting</code>: Initial state after deleting the virtual private gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>deleted</code>: The virtual private gateway is deleted. The private virtual interface is unable to
     *         send traffic over this gateway.
     *         </p>
     *         </li>
     */
    public final String virtualGatewayState() {
        return virtualGatewayState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayId());
        hashCode = 31 * hashCode + Objects.hashCode(virtualGatewayState());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VirtualGateway)) {
            return false;
        }
        VirtualGateway other = (VirtualGateway) obj;
        return Objects.equals(virtualGatewayId(), other.virtualGatewayId())
                && Objects.equals(virtualGatewayState(), other.virtualGatewayState());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VirtualGateway").add("VirtualGatewayId", virtualGatewayId())
                .add("VirtualGatewayState", virtualGatewayState()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualGatewayId":
            return Optional.ofNullable(clazz.cast(virtualGatewayId()));
        case "virtualGatewayState":
            return Optional.ofNullable(clazz.cast(virtualGatewayState()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("virtualGatewayId", VIRTUAL_GATEWAY_ID_FIELD);
        map.put("virtualGatewayState", VIRTUAL_GATEWAY_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VirtualGateway, T> g) {
        return obj -> g.apply((VirtualGateway) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VirtualGateway> {
        /**
         * <p>
         * The ID of the virtual private gateway.
         * </p>
         * 
         * @param virtualGatewayId
         *        The ID of the virtual private gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayId(String virtualGatewayId);

        /**
         * <p>
         * The state of the virtual private gateway. The following are the possible values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>pending</code>: Initial state after creating the virtual private gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>available</code>: Ready for use by a private virtual interface.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleting</code>: Initial state after deleting the virtual private gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>deleted</code>: The virtual private gateway is deleted. The private virtual interface is unable to send
         * traffic over this gateway.
         * </p>
         * </li>
         * </ul>
         * 
         * @param virtualGatewayState
         *        The state of the virtual private gateway. The following are the possible values:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>pending</code>: Initial state after creating the virtual private gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>available</code>: Ready for use by a private virtual interface.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleting</code>: Initial state after deleting the virtual private gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>deleted</code>: The virtual private gateway is deleted. The private virtual interface is unable
         *        to send traffic over this gateway.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGatewayState(String virtualGatewayState);
    }

    static final class BuilderImpl implements Builder {
        private String virtualGatewayId;

        private String virtualGatewayState;

        private BuilderImpl() {
        }

        private BuilderImpl(VirtualGateway model) {
            virtualGatewayId(model.virtualGatewayId);
            virtualGatewayState(model.virtualGatewayState);
        }

        public final String getVirtualGatewayId() {
            return virtualGatewayId;
        }

        public final void setVirtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
        }

        @Override
        public final Builder virtualGatewayId(String virtualGatewayId) {
            this.virtualGatewayId = virtualGatewayId;
            return this;
        }

        public final String getVirtualGatewayState() {
            return virtualGatewayState;
        }

        public final void setVirtualGatewayState(String virtualGatewayState) {
            this.virtualGatewayState = virtualGatewayState;
        }

        @Override
        public final Builder virtualGatewayState(String virtualGatewayState) {
            this.virtualGatewayState = virtualGatewayState;
            return this;
        }

        @Override
        public VirtualGateway build() {
            return new VirtualGateway(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
