/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeCustomerMetadataResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeCustomerMetadataResponse.Builder, DescribeCustomerMetadataResponse> {
    private static final SdkField<List<CustomerAgreement>> AGREEMENTS_FIELD = SdkField
            .<List<CustomerAgreement>> builder(MarshallingType.LIST)
            .memberName("agreements")
            .getter(getter(DescribeCustomerMetadataResponse::agreements))
            .setter(setter(Builder::agreements))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agreements").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CustomerAgreement> builder(MarshallingType.SDK_POJO)
                                            .constructor(CustomerAgreement::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NNI_PARTNER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nniPartnerType").getter(getter(DescribeCustomerMetadataResponse::nniPartnerTypeAsString))
            .setter(setter(Builder::nniPartnerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nniPartnerType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGREEMENTS_FIELD,
            NNI_PARTNER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CustomerAgreement> agreements;

    private final String nniPartnerType;

    private DescribeCustomerMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.agreements = builder.agreements;
        this.nniPartnerType = builder.nniPartnerType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Agreements property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAgreements() {
        return agreements != null && !(agreements instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of customer agreements.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAgreements} method.
     * </p>
     * 
     * @return The list of customer agreements.
     */
    public final List<CustomerAgreement> agreements() {
        return agreements;
    }

    /**
     * <p>
     * The type of network-to-network interface (NNI) partner. The partner type will be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * nonPartner: The customer is not a partner.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nniPartnerType}
     * will return {@link NniPartnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nniPartnerTypeAsString}.
     * </p>
     * 
     * @return The type of network-to-network interface (NNI) partner. The partner type will be one of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit
     *         connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         nonPartner: The customer is not a partner.
     *         </p>
     *         </li>
     * @see NniPartnerType
     */
    public final NniPartnerType nniPartnerType() {
        return NniPartnerType.fromValue(nniPartnerType);
    }

    /**
     * <p>
     * The type of network-to-network interface (NNI) partner. The partner type will be one of the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.
     * </p>
     * </li>
     * <li>
     * <p>
     * nonPartner: The customer is not a partner.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nniPartnerType}
     * will return {@link NniPartnerType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #nniPartnerTypeAsString}.
     * </p>
     * 
     * @return The type of network-to-network interface (NNI) partner. The partner type will be one of the
     *         following:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit
     *         connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         nonPartner: The customer is not a partner.
     *         </p>
     *         </li>
     * @see NniPartnerType
     */
    public final String nniPartnerTypeAsString() {
        return nniPartnerType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAgreements() ? agreements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nniPartnerTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomerMetadataResponse)) {
            return false;
        }
        DescribeCustomerMetadataResponse other = (DescribeCustomerMetadataResponse) obj;
        return hasAgreements() == other.hasAgreements() && Objects.equals(agreements(), other.agreements())
                && Objects.equals(nniPartnerTypeAsString(), other.nniPartnerTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeCustomerMetadataResponse").add("Agreements", hasAgreements() ? agreements() : null)
                .add("NniPartnerType", nniPartnerTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "agreements":
            return Optional.ofNullable(clazz.cast(agreements()));
        case "nniPartnerType":
            return Optional.ofNullable(clazz.cast(nniPartnerTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("agreements", AGREEMENTS_FIELD);
        map.put("nniPartnerType", NNI_PARTNER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomerMetadataResponse, T> g) {
        return obj -> g.apply((DescribeCustomerMetadataResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeCustomerMetadataResponse> {
        /**
         * <p>
         * The list of customer agreements.
         * </p>
         * 
         * @param agreements
         *        The list of customer agreements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreements(Collection<CustomerAgreement> agreements);

        /**
         * <p>
         * The list of customer agreements.
         * </p>
         * 
         * @param agreements
         *        The list of customer agreements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agreements(CustomerAgreement... agreements);

        /**
         * <p>
         * The list of customer agreements.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.directconnect.model.CustomerAgreement.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.directconnect.model.CustomerAgreement#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.directconnect.model.CustomerAgreement.Builder#build()} is called
         * immediately and its result is passed to {@link #agreements(List<CustomerAgreement>)}.
         * 
         * @param agreements
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.directconnect.model.CustomerAgreement.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #agreements(java.util.Collection<CustomerAgreement>)
         */
        Builder agreements(Consumer<CustomerAgreement.Builder>... agreements);

        /**
         * <p>
         * The type of network-to-network interface (NNI) partner. The partner type will be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit
         * connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * nonPartner: The customer is not a partner.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nniPartnerType
         *        The type of network-to-network interface (NNI) partner. The partner type will be one of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit
         *        connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        nonPartner: The customer is not a partner.
         *        </p>
         *        </li>
         * @see NniPartnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NniPartnerType
         */
        Builder nniPartnerType(String nniPartnerType);

        /**
         * <p>
         * The type of network-to-network interface (NNI) partner. The partner type will be one of the following:
         * </p>
         * <ul>
         * <li>
         * <p>
         * V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit
         * connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.
         * </p>
         * </li>
         * <li>
         * <p>
         * nonPartner: The customer is not a partner.
         * </p>
         * </li>
         * </ul>
         * 
         * @param nniPartnerType
         *        The type of network-to-network interface (NNI) partner. The partner type will be one of the
         *        following:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        V1: This partner can only allocate 50Mbps, 100Mbps, 200Mbps, 300Mbps, 400Mbps, or 500Mbps subgigabit
         *        connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        V2: This partner can only allocate 1GB, 2GB, 5GB, or 10GB hosted connections.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        nonPartner: The customer is not a partner.
         *        </p>
         *        </li>
         * @see NniPartnerType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NniPartnerType
         */
        Builder nniPartnerType(NniPartnerType nniPartnerType);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<CustomerAgreement> agreements = DefaultSdkAutoConstructList.getInstance();

        private String nniPartnerType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomerMetadataResponse model) {
            super(model);
            agreements(model.agreements);
            nniPartnerType(model.nniPartnerType);
        }

        public final List<CustomerAgreement.Builder> getAgreements() {
            List<CustomerAgreement.Builder> result = AgreementListCopier.copyToBuilder(this.agreements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAgreements(Collection<CustomerAgreement.BuilderImpl> agreements) {
            this.agreements = AgreementListCopier.copyFromBuilder(agreements);
        }

        @Override
        public final Builder agreements(Collection<CustomerAgreement> agreements) {
            this.agreements = AgreementListCopier.copy(agreements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreements(CustomerAgreement... agreements) {
            agreements(Arrays.asList(agreements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder agreements(Consumer<CustomerAgreement.Builder>... agreements) {
            agreements(Stream.of(agreements).map(c -> CustomerAgreement.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNniPartnerType() {
            return nniPartnerType;
        }

        public final void setNniPartnerType(String nniPartnerType) {
            this.nniPartnerType = nniPartnerType;
        }

        @Override
        public final Builder nniPartnerType(String nniPartnerType) {
            this.nniPartnerType = nniPartnerType;
            return this;
        }

        @Override
        public final Builder nniPartnerType(NniPartnerType nniPartnerType) {
            this.nniPartnerType(nniPartnerType == null ? null : nniPartnerType.toString());
            return this;
        }

        @Override
        public DescribeCustomerMetadataResponse build() {
            return new DescribeCustomerMetadataResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
