/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRouterConfigurationRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, DescribeRouterConfigurationRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(DescribeRouterConfigurationRequest.getter(DescribeRouterConfigurationRequest::virtualInterfaceId)).setter(DescribeRouterConfigurationRequest.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<String> ROUTER_TYPE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("routerTypeIdentifier").getter(DescribeRouterConfigurationRequest.getter(DescribeRouterConfigurationRequest::routerTypeIdentifier)).setter(DescribeRouterConfigurationRequest.setter(Builder::routerTypeIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("routerTypeIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD, ROUTER_TYPE_IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRouterConfigurationRequest.memberNameToFieldInitializer();
    private final String virtualInterfaceId;
    private final String routerTypeIdentifier;

    private DescribeRouterConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.routerTypeIdentifier = builder.routerTypeIdentifier;
    }

    public final String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public final String routerTypeIdentifier() {
        return this.routerTypeIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.routerTypeIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouterConfigurationRequest)) {
            return false;
        }
        DescribeRouterConfigurationRequest other = (DescribeRouterConfigurationRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.routerTypeIdentifier(), other.routerTypeIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRouterConfigurationRequest").add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("RouterTypeIdentifier", (Object)this.routerTypeIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "routerTypeIdentifier": {
                return Optional.ofNullable(clazz.cast(this.routerTypeIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("virtualInterfaceId", VIRTUAL_INTERFACE_ID_FIELD);
        map.put("routerTypeIdentifier", ROUTER_TYPE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRouterConfigurationRequest, T> g) {
        return obj -> g.apply((DescribeRouterConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private String routerTypeIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouterConfigurationRequest model) {
            super(model);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.routerTypeIdentifier(model.routerTypeIdentifier);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final String getRouterTypeIdentifier() {
            return this.routerTypeIdentifier;
        }

        public final void setRouterTypeIdentifier(String routerTypeIdentifier) {
            this.routerTypeIdentifier = routerTypeIdentifier;
        }

        @Override
        public final Builder routerTypeIdentifier(String routerTypeIdentifier) {
            this.routerTypeIdentifier = routerTypeIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeRouterConfigurationRequest build() {
            return new DescribeRouterConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRouterConfigurationRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder routerTypeIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

