/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGateway;
import software.amazon.awssdk.services.directconnect.model.DirectConnectGatewayListCopier;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDirectConnectGatewaysResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeDirectConnectGatewaysResponse> {
    private static final SdkField<List<DirectConnectGateway>> DIRECT_CONNECT_GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("directConnectGateways").getter(DescribeDirectConnectGatewaysResponse.getter(DescribeDirectConnectGatewaysResponse::directConnectGateways)).setter(DescribeDirectConnectGatewaysResponse.setter(Builder::directConnectGateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGateways").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DirectConnectGateway::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeDirectConnectGatewaysResponse.getter(DescribeDirectConnectGatewaysResponse::nextToken)).setter(DescribeDirectConnectGatewaysResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECT_CONNECT_GATEWAYS_FIELD, NEXT_TOKEN_FIELD));
    private final List<DirectConnectGateway> directConnectGateways;
    private final String nextToken;

    private DescribeDirectConnectGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGateways = builder.directConnectGateways;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasDirectConnectGateways() {
        return this.directConnectGateways != null && !(this.directConnectGateways instanceof SdkAutoConstructList);
    }

    public final List<DirectConnectGateway> directConnectGateways() {
        return this.directConnectGateways;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDirectConnectGateways() ? this.directConnectGateways() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDirectConnectGatewaysResponse)) {
            return false;
        }
        DescribeDirectConnectGatewaysResponse other = (DescribeDirectConnectGatewaysResponse)((Object)obj);
        return this.hasDirectConnectGateways() == other.hasDirectConnectGateways() && Objects.equals(this.directConnectGateways(), other.directConnectGateways()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDirectConnectGatewaysResponse").add("DirectConnectGateways", this.hasDirectConnectGateways() ? this.directConnectGateways() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "directConnectGateways": {
                return Optional.ofNullable(clazz.cast(this.directConnectGateways()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDirectConnectGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeDirectConnectGatewaysResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private List<DirectConnectGateway> directConnectGateways = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDirectConnectGatewaysResponse model) {
            super(model);
            this.directConnectGateways(model.directConnectGateways);
            this.nextToken(model.nextToken);
        }

        public final List<DirectConnectGateway.Builder> getDirectConnectGateways() {
            List<DirectConnectGateway.Builder> result = DirectConnectGatewayListCopier.copyToBuilder(this.directConnectGateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDirectConnectGateways(Collection<DirectConnectGateway.BuilderImpl> directConnectGateways) {
            this.directConnectGateways = DirectConnectGatewayListCopier.copyFromBuilder(directConnectGateways);
        }

        @Override
        public final Builder directConnectGateways(Collection<DirectConnectGateway> directConnectGateways) {
            this.directConnectGateways = DirectConnectGatewayListCopier.copy(directConnectGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGateways(DirectConnectGateway ... directConnectGateways) {
            this.directConnectGateways(Arrays.asList(directConnectGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder directConnectGateways(Consumer<DirectConnectGateway.Builder> ... directConnectGateways) {
            this.directConnectGateways(Stream.of(directConnectGateways).map(c -> (DirectConnectGateway)((DirectConnectGateway.Builder)DirectConnectGateway.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeDirectConnectGatewaysResponse build() {
            return new DescribeDirectConnectGatewaysResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDirectConnectGatewaysResponse> {
        public Builder directConnectGateways(Collection<DirectConnectGateway> var1);

        public Builder directConnectGateways(DirectConnectGateway ... var1);

        public Builder directConnectGateways(Consumer<DirectConnectGateway.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

