/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.beans.Transient;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectResponse;
import software.amazon.awssdk.services.directconnect.model.LoaContentType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLoaResponse
extends DirectConnectResponse
implements ToCopyableBuilder<Builder, DescribeLoaResponse> {
    private static final SdkField<SdkBytes> LOA_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("loaContent").getter(DescribeLoaResponse.getter(DescribeLoaResponse::loaContent)).setter(DescribeLoaResponse.setter(Builder::loaContent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaContent").build()}).build();
    private static final SdkField<String> LOA_CONTENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("loaContentType").getter(DescribeLoaResponse.getter(DescribeLoaResponse::loaContentTypeAsString)).setter(DescribeLoaResponse.setter(Builder::loaContentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loaContentType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOA_CONTENT_FIELD, LOA_CONTENT_TYPE_FIELD));
    private final SdkBytes loaContent;
    private final String loaContentType;

    private DescribeLoaResponse(BuilderImpl builder) {
        super(builder);
        this.loaContent = builder.loaContent;
        this.loaContentType = builder.loaContentType;
    }

    public final SdkBytes loaContent() {
        return this.loaContent;
    }

    public final LoaContentType loaContentType() {
        return LoaContentType.fromValue(this.loaContentType);
    }

    public final String loaContentTypeAsString() {
        return this.loaContentType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.loaContentTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLoaResponse)) {
            return false;
        }
        DescribeLoaResponse other = (DescribeLoaResponse)((Object)obj);
        return Objects.equals(this.loaContent(), other.loaContent()) && Objects.equals(this.loaContentTypeAsString(), other.loaContentTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeLoaResponse").add("LoaContent", (Object)this.loaContent()).add("LoaContentType", (Object)this.loaContentTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "loaContent": {
                return Optional.ofNullable(clazz.cast(this.loaContent()));
            }
            case "loaContentType": {
                return Optional.ofNullable(clazz.cast(this.loaContentTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLoaResponse, T> g) {
        return obj -> g.apply((DescribeLoaResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectResponse.BuilderImpl
    implements Builder {
        private SdkBytes loaContent;
        private String loaContentType;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLoaResponse model) {
            super(model);
            this.loaContent(model.loaContent);
            this.loaContentType(model.loaContentType);
        }

        public final ByteBuffer getLoaContent() {
            return this.loaContent == null ? null : this.loaContent.asByteBuffer();
        }

        public final void setLoaContent(ByteBuffer loaContent) {
            this.loaContent(loaContent == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)loaContent));
        }

        @Override
        @Transient
        public final Builder loaContent(SdkBytes loaContent) {
            this.loaContent = loaContent;
            return this;
        }

        public final String getLoaContentType() {
            return this.loaContentType;
        }

        public final void setLoaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
        }

        @Override
        @Transient
        public final Builder loaContentType(String loaContentType) {
            this.loaContentType = loaContentType;
            return this;
        }

        @Override
        @Transient
        public final Builder loaContentType(LoaContentType loaContentType) {
            this.loaContentType(loaContentType == null ? null : loaContentType.toString());
            return this;
        }

        @Override
        public DescribeLoaResponse build() {
            return new DescribeLoaResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLoaResponse> {
        public Builder loaContent(SdkBytes var1);

        public Builder loaContentType(String var1);

        public Builder loaContentType(LoaContentType var1);
    }
}

