/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVirtualInterfaceTestHistoryResponse extends DirectConnectResponse implements
        ToCopyableBuilder<ListVirtualInterfaceTestHistoryResponse.Builder, ListVirtualInterfaceTestHistoryResponse> {
    private static final SdkField<List<VirtualInterfaceTestHistory>> VIRTUAL_INTERFACE_TEST_HISTORY_FIELD = SdkField
            .<List<VirtualInterfaceTestHistory>> builder(MarshallingType.LIST)
            .memberName("virtualInterfaceTestHistory")
            .getter(getter(ListVirtualInterfaceTestHistoryResponse::virtualInterfaceTestHistory))
            .setter(setter(Builder::virtualInterfaceTestHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceTestHistory")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualInterfaceTestHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualInterfaceTestHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVirtualInterfaceTestHistoryResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VIRTUAL_INTERFACE_TEST_HISTORY_FIELD, NEXT_TOKEN_FIELD));

    private final List<VirtualInterfaceTestHistory> virtualInterfaceTestHistory;

    private final String nextToken;

    private ListVirtualInterfaceTestHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceTestHistory = builder.virtualInterfaceTestHistory;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the VirtualInterfaceTestHistory property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public final boolean hasVirtualInterfaceTestHistory() {
        return virtualInterfaceTestHistory != null && !(virtualInterfaceTestHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ID of the tested virtual interface.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVirtualInterfaceTestHistory()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The ID of the tested virtual interface.
     */
    public final List<VirtualInterfaceTestHistory> virtualInterfaceTestHistory() {
        return virtualInterfaceTestHistory;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVirtualInterfaceTestHistory() ? virtualInterfaceTestHistory() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVirtualInterfaceTestHistoryResponse)) {
            return false;
        }
        ListVirtualInterfaceTestHistoryResponse other = (ListVirtualInterfaceTestHistoryResponse) obj;
        return hasVirtualInterfaceTestHistory() == other.hasVirtualInterfaceTestHistory()
                && Objects.equals(virtualInterfaceTestHistory(), other.virtualInterfaceTestHistory())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVirtualInterfaceTestHistoryResponse")
                .add("VirtualInterfaceTestHistory", hasVirtualInterfaceTestHistory() ? virtualInterfaceTestHistory() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceTestHistory":
            return Optional.ofNullable(clazz.cast(virtualInterfaceTestHistory()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListVirtualInterfaceTestHistoryResponse, T> g) {
        return obj -> g.apply((ListVirtualInterfaceTestHistoryResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVirtualInterfaceTestHistoryResponse> {
        /**
         * <p>
         * The ID of the tested virtual interface.
         * </p>
         * 
         * @param virtualInterfaceTestHistory
         *        The ID of the tested virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceTestHistory(Collection<VirtualInterfaceTestHistory> virtualInterfaceTestHistory);

        /**
         * <p>
         * The ID of the tested virtual interface.
         * </p>
         * 
         * @param virtualInterfaceTestHistory
         *        The ID of the tested virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceTestHistory(VirtualInterfaceTestHistory... virtualInterfaceTestHistory);

        /**
         * <p>
         * The ID of the tested virtual interface.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VirtualInterfaceTestHistory>.Builder}
         * avoiding the need to create one manually via {@link List<VirtualInterfaceTestHistory>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualInterfaceTestHistory>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #virtualInterfaceTestHistory(List<VirtualInterfaceTestHistory>)}.
         * 
         * @param virtualInterfaceTestHistory
         *        a consumer that will call methods on {@link List<VirtualInterfaceTestHistory>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualInterfaceTestHistory(List<VirtualInterfaceTestHistory>)
         */
        Builder virtualInterfaceTestHistory(Consumer<VirtualInterfaceTestHistory.Builder>... virtualInterfaceTestHistory);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<VirtualInterfaceTestHistory> virtualInterfaceTestHistory = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVirtualInterfaceTestHistoryResponse model) {
            super(model);
            virtualInterfaceTestHistory(model.virtualInterfaceTestHistory);
            nextToken(model.nextToken);
        }

        public final Collection<VirtualInterfaceTestHistory.Builder> getVirtualInterfaceTestHistory() {
            if (virtualInterfaceTestHistory instanceof SdkAutoConstructList) {
                return null;
            }
            return virtualInterfaceTestHistory != null ? virtualInterfaceTestHistory.stream()
                    .map(VirtualInterfaceTestHistory::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder virtualInterfaceTestHistory(Collection<VirtualInterfaceTestHistory> virtualInterfaceTestHistory) {
            this.virtualInterfaceTestHistory = VirtualInterfaceTestHistoryListCopier.copy(virtualInterfaceTestHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualInterfaceTestHistory(VirtualInterfaceTestHistory... virtualInterfaceTestHistory) {
            virtualInterfaceTestHistory(Arrays.asList(virtualInterfaceTestHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualInterfaceTestHistory(
                Consumer<VirtualInterfaceTestHistory.Builder>... virtualInterfaceTestHistory) {
            virtualInterfaceTestHistory(Stream.of(virtualInterfaceTestHistory)
                    .map(c -> VirtualInterfaceTestHistory.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setVirtualInterfaceTestHistory(
                Collection<VirtualInterfaceTestHistory.BuilderImpl> virtualInterfaceTestHistory) {
            this.virtualInterfaceTestHistory = VirtualInterfaceTestHistoryListCopier.copyFromBuilder(virtualInterfaceTestHistory);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListVirtualInterfaceTestHistoryResponse build() {
            return new ListVirtualInterfaceTestHistoryResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
