/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.directconnect.model.DirectConnectRequest;
import software.amazon.awssdk.services.directconnect.model.NewBGPPeer;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBgpPeerRequest
extends DirectConnectRequest
implements ToCopyableBuilder<Builder, CreateBgpPeerRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("virtualInterfaceId").getter(CreateBgpPeerRequest.getter(CreateBgpPeerRequest::virtualInterfaceId)).setter(CreateBgpPeerRequest.setter(Builder::virtualInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build()}).build();
    private static final SdkField<NewBGPPeer> NEW_BGP_PEER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("newBGPPeer").getter(CreateBgpPeerRequest.getter(CreateBgpPeerRequest::newBGPPeer)).setter(CreateBgpPeerRequest.setter(Builder::newBGPPeer)).constructor(NewBGPPeer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newBGPPeer").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD, NEW_BGP_PEER_FIELD));
    private final String virtualInterfaceId;
    private final NewBGPPeer newBGPPeer;

    private CreateBgpPeerRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.newBGPPeer = builder.newBGPPeer;
    }

    public String virtualInterfaceId() {
        return this.virtualInterfaceId;
    }

    public NewBGPPeer newBGPPeer() {
        return this.newBGPPeer;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.newBGPPeer());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBgpPeerRequest)) {
            return false;
        }
        CreateBgpPeerRequest other = (CreateBgpPeerRequest)((Object)obj);
        return Objects.equals(this.virtualInterfaceId(), other.virtualInterfaceId()) && Objects.equals(this.newBGPPeer(), other.newBGPPeer());
    }

    public String toString() {
        return ToString.builder((String)"CreateBgpPeerRequest").add("VirtualInterfaceId", (Object)this.virtualInterfaceId()).add("NewBGPPeer", (Object)this.newBGPPeer()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "virtualInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.virtualInterfaceId()));
            }
            case "newBGPPeer": {
                return Optional.ofNullable(clazz.cast(this.newBGPPeer()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateBgpPeerRequest, T> g) {
        return obj -> g.apply((CreateBgpPeerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DirectConnectRequest.BuilderImpl
    implements Builder {
        private String virtualInterfaceId;
        private NewBGPPeer newBGPPeer;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBgpPeerRequest model) {
            super(model);
            this.virtualInterfaceId(model.virtualInterfaceId);
            this.newBGPPeer(model.newBGPPeer);
        }

        public final String getVirtualInterfaceId() {
            return this.virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final NewBGPPeer.Builder getNewBGPPeer() {
            return this.newBGPPeer != null ? this.newBGPPeer.toBuilder() : null;
        }

        @Override
        public final Builder newBGPPeer(NewBGPPeer newBGPPeer) {
            this.newBGPPeer = newBGPPeer;
            return this;
        }

        public final void setNewBGPPeer(NewBGPPeer.BuilderImpl newBGPPeer) {
            this.newBGPPeer = newBGPPeer != null ? newBGPPeer.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBgpPeerRequest build() {
            return new CreateBgpPeerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DirectConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBgpPeerRequest> {
        public Builder virtualInterfaceId(String var1);

        public Builder newBGPPeer(NewBGPPeer var1);

        default public Builder newBGPPeer(Consumer<NewBGPPeer.Builder> newBGPPeer) {
            return this.newBGPPeer((NewBGPPeer)((NewBGPPeer.Builder)NewBGPPeer.builder().applyMutation(newBGPPeer)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

