/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDirectConnectGatewayAssociationRequest extends DirectConnectRequest implements
        ToCopyableBuilder<UpdateDirectConnectGatewayAssociationRequest.Builder, UpdateDirectConnectGatewayAssociationRequest> {
    private static final SdkField<String> ASSOCIATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UpdateDirectConnectGatewayAssociationRequest::associationId)).setter(setter(Builder::associationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationId").build()).build();

    private static final SdkField<List<RouteFilterPrefix>> ADD_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDirectConnectGatewayAssociationRequest::addAllowedPrefixesToDirectConnectGateway))
            .setter(setter(Builder::addAllowedPrefixesToDirectConnectGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("addAllowedPrefixesToDirectConnectGateway").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RouteFilterPrefix>> REMOVE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD = SdkField
            .<List<RouteFilterPrefix>> builder(MarshallingType.LIST)
            .getter(getter(UpdateDirectConnectGatewayAssociationRequest::removeAllowedPrefixesToDirectConnectGateway))
            .setter(setter(Builder::removeAllowedPrefixesToDirectConnectGateway))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("removeAllowedPrefixesToDirectConnectGateway").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RouteFilterPrefix> builder(MarshallingType.SDK_POJO)
                                            .constructor(RouteFilterPrefix::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATION_ID_FIELD,
            ADD_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD, REMOVE_ALLOWED_PREFIXES_TO_DIRECT_CONNECT_GATEWAY_FIELD));

    private final String associationId;

    private final List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway;

    private final List<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway;

    private UpdateDirectConnectGatewayAssociationRequest(BuilderImpl builder) {
        super(builder);
        this.associationId = builder.associationId;
        this.addAllowedPrefixesToDirectConnectGateway = builder.addAllowedPrefixesToDirectConnectGateway;
        this.removeAllowedPrefixesToDirectConnectGateway = builder.removeAllowedPrefixesToDirectConnectGateway;
    }

    /**
     * <p>
     * The ID of the Direct Connect gateway association.
     * </p>
     * 
     * @return The ID of the Direct Connect gateway association.
     */
    public String associationId() {
        return associationId;
    }

    /**
     * Returns true if the AddAllowedPrefixesToDirectConnectGateway property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasAddAllowedPrefixesToDirectConnectGateway() {
        return addAllowedPrefixesToDirectConnectGateway != null
                && !(addAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAddAllowedPrefixesToDirectConnectGateway()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon VPC prefixes to advertise to the Direct Connect gateway.
     */
    public List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway() {
        return addAllowedPrefixesToDirectConnectGateway;
    }

    /**
     * Returns true if the RemoveAllowedPrefixesToDirectConnectGateway property was specified by the sender (it may be
     * empty), or false if the sender did not specify the value (it will be empty). For responses returned by the SDK,
     * the sender is the AWS service.
     */
    public boolean hasRemoveAllowedPrefixesToDirectConnectGateway() {
        return removeAllowedPrefixesToDirectConnectGateway != null
                && !(removeAllowedPrefixesToDirectConnectGateway instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasRemoveAllowedPrefixesToDirectConnectGateway()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
     */
    public List<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway() {
        return removeAllowedPrefixesToDirectConnectGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(associationId());
        hashCode = 31 * hashCode + Objects.hashCode(addAllowedPrefixesToDirectConnectGateway());
        hashCode = 31 * hashCode + Objects.hashCode(removeAllowedPrefixesToDirectConnectGateway());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectConnectGatewayAssociationRequest)) {
            return false;
        }
        UpdateDirectConnectGatewayAssociationRequest other = (UpdateDirectConnectGatewayAssociationRequest) obj;
        return Objects.equals(associationId(), other.associationId())
                && Objects.equals(addAllowedPrefixesToDirectConnectGateway(), other.addAllowedPrefixesToDirectConnectGateway())
                && Objects.equals(removeAllowedPrefixesToDirectConnectGateway(),
                        other.removeAllowedPrefixesToDirectConnectGateway());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateDirectConnectGatewayAssociationRequest").add("AssociationId", associationId())
                .add("AddAllowedPrefixesToDirectConnectGateway", addAllowedPrefixesToDirectConnectGateway())
                .add("RemoveAllowedPrefixesToDirectConnectGateway", removeAllowedPrefixesToDirectConnectGateway()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associationId":
            return Optional.ofNullable(clazz.cast(associationId()));
        case "addAllowedPrefixesToDirectConnectGateway":
            return Optional.ofNullable(clazz.cast(addAllowedPrefixesToDirectConnectGateway()));
        case "removeAllowedPrefixesToDirectConnectGateway":
            return Optional.ofNullable(clazz.cast(removeAllowedPrefixesToDirectConnectGateway()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectConnectGatewayAssociationRequest, T> g) {
        return obj -> g.apply((UpdateDirectConnectGatewayAssociationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDirectConnectGatewayAssociationRequest> {
        /**
         * <p>
         * The ID of the Direct Connect gateway association.
         * </p>
         * 
         * @param associationId
         *        The ID of the Direct Connect gateway association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * 
         * @param addAllowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedPrefixesToDirectConnectGateway(Collection<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * 
         * @param addAllowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix... addAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to advertise to the Direct Connect gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteFilterPrefix>.Builder} avoiding the
         * need to create one manually via {@link List<RouteFilterPrefix>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteFilterPrefix>.Builder#build()} is called immediately
         * and its result is passed to {@link #addAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)}.
         * 
         * @param addAllowedPrefixesToDirectConnectGateway
         *        a consumer that will call methods on {@link List<RouteFilterPrefix>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)
         */
        Builder addAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... addAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
         * </p>
         * 
         * @param removeAllowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
         * </p>
         * 
         * @param removeAllowedPrefixesToDirectConnectGateway
         *        The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removeAllowedPrefixesToDirectConnectGateway(RouteFilterPrefix... removeAllowedPrefixesToDirectConnectGateway);

        /**
         * <p>
         * The Amazon VPC prefixes to no longer advertise to the Direct Connect gateway.
         * </p>
         * This is a convenience that creates an instance of the {@link List<RouteFilterPrefix>.Builder} avoiding the
         * need to create one manually via {@link List<RouteFilterPrefix>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RouteFilterPrefix>.Builder#build()} is called immediately
         * and its result is passed to {@link #removeAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)}.
         * 
         * @param removeAllowedPrefixesToDirectConnectGateway
         *        a consumer that will call methods on {@link List<RouteFilterPrefix>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removeAllowedPrefixesToDirectConnectGateway(List<RouteFilterPrefix>)
         */
        Builder removeAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... removeAllowedPrefixesToDirectConnectGateway);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String associationId;

        private List<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private List<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectConnectGatewayAssociationRequest model) {
            super(model);
            associationId(model.associationId);
            addAllowedPrefixesToDirectConnectGateway(model.addAllowedPrefixesToDirectConnectGateway);
            removeAllowedPrefixesToDirectConnectGateway(model.removeAllowedPrefixesToDirectConnectGateway);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        public final Collection<RouteFilterPrefix.Builder> getAddAllowedPrefixesToDirectConnectGateway() {
            return addAllowedPrefixesToDirectConnectGateway != null ? addAllowedPrefixesToDirectConnectGateway.stream()
                    .map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder addAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copy(addAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrefixesToDirectConnectGateway(
                RouteFilterPrefix... addAllowedPrefixesToDirectConnectGateway) {
            addAllowedPrefixesToDirectConnectGateway(Arrays.asList(addAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder addAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... addAllowedPrefixesToDirectConnectGateway) {
            addAllowedPrefixesToDirectConnectGateway(Stream.of(addAllowedPrefixesToDirectConnectGateway)
                    .map(c -> RouteFilterPrefix.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAddAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix.BuilderImpl> addAllowedPrefixesToDirectConnectGateway) {
            this.addAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copyFromBuilder(addAllowedPrefixesToDirectConnectGateway);
        }

        public final Collection<RouteFilterPrefix.Builder> getRemoveAllowedPrefixesToDirectConnectGateway() {
            return removeAllowedPrefixesToDirectConnectGateway != null ? removeAllowedPrefixesToDirectConnectGateway.stream()
                    .map(RouteFilterPrefix::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder removeAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix> removeAllowedPrefixesToDirectConnectGateway) {
            this.removeAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copy(removeAllowedPrefixesToDirectConnectGateway);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedPrefixesToDirectConnectGateway(
                RouteFilterPrefix... removeAllowedPrefixesToDirectConnectGateway) {
            removeAllowedPrefixesToDirectConnectGateway(Arrays.asList(removeAllowedPrefixesToDirectConnectGateway));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder removeAllowedPrefixesToDirectConnectGateway(
                Consumer<RouteFilterPrefix.Builder>... removeAllowedPrefixesToDirectConnectGateway) {
            removeAllowedPrefixesToDirectConnectGateway(Stream.of(removeAllowedPrefixesToDirectConnectGateway)
                    .map(c -> RouteFilterPrefix.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setRemoveAllowedPrefixesToDirectConnectGateway(
                Collection<RouteFilterPrefix.BuilderImpl> removeAllowedPrefixesToDirectConnectGateway) {
            this.removeAllowedPrefixesToDirectConnectGateway = RouteFilterPrefixListCopier
                    .copyFromBuilder(removeAllowedPrefixesToDirectConnectGateway);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectConnectGatewayAssociationRequest build() {
            return new UpdateDirectConnectGatewayAssociationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
