/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVirtualGatewaysResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DescribeVirtualGatewaysResponse.Builder, DescribeVirtualGatewaysResponse> {
    private static final SdkField<List<VirtualGateway>> VIRTUAL_GATEWAYS_FIELD = SdkField
            .<List<VirtualGateway>> builder(MarshallingType.LIST)
            .getter(getter(DescribeVirtualGatewaysResponse::virtualGateways))
            .setter(setter(Builder::virtualGateways))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualGateways").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VirtualGateway> builder(MarshallingType.SDK_POJO)
                                            .constructor(VirtualGateway::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_GATEWAYS_FIELD));

    private final List<VirtualGateway> virtualGateways;

    private DescribeVirtualGatewaysResponse(BuilderImpl builder) {
        super(builder);
        this.virtualGateways = builder.virtualGateways;
    }

    /**
     * Returns true if the VirtualGateways property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasVirtualGateways() {
        return virtualGateways != null && !(virtualGateways instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The virtual private gateways.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasVirtualGateways()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The virtual private gateways.
     */
    public List<VirtualGateway> virtualGateways() {
        return virtualGateways;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualGateways());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVirtualGatewaysResponse)) {
            return false;
        }
        DescribeVirtualGatewaysResponse other = (DescribeVirtualGatewaysResponse) obj;
        return Objects.equals(virtualGateways(), other.virtualGateways());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeVirtualGatewaysResponse").add("VirtualGateways", virtualGateways()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualGateways":
            return Optional.ofNullable(clazz.cast(virtualGateways()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeVirtualGatewaysResponse, T> g) {
        return obj -> g.apply((DescribeVirtualGatewaysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeVirtualGatewaysResponse> {
        /**
         * <p>
         * The virtual private gateways.
         * </p>
         * 
         * @param virtualGateways
         *        The virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGateways(Collection<VirtualGateway> virtualGateways);

        /**
         * <p>
         * The virtual private gateways.
         * </p>
         * 
         * @param virtualGateways
         *        The virtual private gateways.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualGateways(VirtualGateway... virtualGateways);

        /**
         * <p>
         * The virtual private gateways.
         * </p>
         * This is a convenience that creates an instance of the {@link List<VirtualGateway>.Builder} avoiding the need
         * to create one manually via {@link List<VirtualGateway>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<VirtualGateway>.Builder#build()} is called immediately and
         * its result is passed to {@link #virtualGateways(List<VirtualGateway>)}.
         * 
         * @param virtualGateways
         *        a consumer that will call methods on {@link List<VirtualGateway>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #virtualGateways(List<VirtualGateway>)
         */
        Builder virtualGateways(Consumer<VirtualGateway.Builder>... virtualGateways);
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private List<VirtualGateway> virtualGateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVirtualGatewaysResponse model) {
            super(model);
            virtualGateways(model.virtualGateways);
        }

        public final Collection<VirtualGateway.Builder> getVirtualGateways() {
            return virtualGateways != null ? virtualGateways.stream().map(VirtualGateway::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder virtualGateways(Collection<VirtualGateway> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copy(virtualGateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(VirtualGateway... virtualGateways) {
            virtualGateways(Arrays.asList(virtualGateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder virtualGateways(Consumer<VirtualGateway.Builder>... virtualGateways) {
            virtualGateways(Stream.of(virtualGateways).map(c -> VirtualGateway.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setVirtualGateways(Collection<VirtualGateway.BuilderImpl> virtualGateways) {
            this.virtualGateways = VirtualGatewayListCopier.copyFromBuilder(virtualGateways);
        }

        @Override
        public DescribeVirtualGatewaysResponse build() {
            return new DescribeVirtualGatewaysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
