/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteDirectConnectGatewayAssociationResponse extends DirectConnectResponse implements
        ToCopyableBuilder<DeleteDirectConnectGatewayAssociationResponse.Builder, DeleteDirectConnectGatewayAssociationResponse> {
    private static final SdkField<DirectConnectGatewayAssociation> DIRECT_CONNECT_GATEWAY_ASSOCIATION_FIELD = SdkField
            .<DirectConnectGatewayAssociation> builder(MarshallingType.SDK_POJO)
            .getter(getter(DeleteDirectConnectGatewayAssociationResponse::directConnectGatewayAssociation))
            .setter(setter(Builder::directConnectGatewayAssociation))
            .constructor(DirectConnectGatewayAssociation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("directConnectGatewayAssociation")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DIRECT_CONNECT_GATEWAY_ASSOCIATION_FIELD));

    private final DirectConnectGatewayAssociation directConnectGatewayAssociation;

    private DeleteDirectConnectGatewayAssociationResponse(BuilderImpl builder) {
        super(builder);
        this.directConnectGatewayAssociation = builder.directConnectGatewayAssociation;
    }

    /**
     * <p>
     * Information about the deleted association.
     * </p>
     * 
     * @return Information about the deleted association.
     */
    public DirectConnectGatewayAssociation directConnectGatewayAssociation() {
        return directConnectGatewayAssociation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(directConnectGatewayAssociation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteDirectConnectGatewayAssociationResponse)) {
            return false;
        }
        DeleteDirectConnectGatewayAssociationResponse other = (DeleteDirectConnectGatewayAssociationResponse) obj;
        return Objects.equals(directConnectGatewayAssociation(), other.directConnectGatewayAssociation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteDirectConnectGatewayAssociationResponse")
                .add("DirectConnectGatewayAssociation", directConnectGatewayAssociation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "directConnectGatewayAssociation":
            return Optional.ofNullable(clazz.cast(directConnectGatewayAssociation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteDirectConnectGatewayAssociationResponse, T> g) {
        return obj -> g.apply((DeleteDirectConnectGatewayAssociationResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteDirectConnectGatewayAssociationResponse> {
        /**
         * <p>
         * Information about the deleted association.
         * </p>
         * 
         * @param directConnectGatewayAssociation
         *        Information about the deleted association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directConnectGatewayAssociation(DirectConnectGatewayAssociation directConnectGatewayAssociation);

        /**
         * <p>
         * Information about the deleted association.
         * </p>
         * This is a convenience that creates an instance of the {@link DirectConnectGatewayAssociation.Builder}
         * avoiding the need to create one manually via {@link DirectConnectGatewayAssociation#builder()}.
         *
         * When the {@link Consumer} completes, {@link DirectConnectGatewayAssociation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #directConnectGatewayAssociation(DirectConnectGatewayAssociation)}.
         * 
         * @param directConnectGatewayAssociation
         *        a consumer that will call methods on {@link DirectConnectGatewayAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #directConnectGatewayAssociation(DirectConnectGatewayAssociation)
         */
        default Builder directConnectGatewayAssociation(
                Consumer<DirectConnectGatewayAssociation.Builder> directConnectGatewayAssociation) {
            return directConnectGatewayAssociation(DirectConnectGatewayAssociation.builder()
                    .applyMutation(directConnectGatewayAssociation).build());
        }
    }

    static final class BuilderImpl extends DirectConnectResponse.BuilderImpl implements Builder {
        private DirectConnectGatewayAssociation directConnectGatewayAssociation;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteDirectConnectGatewayAssociationResponse model) {
            super(model);
            directConnectGatewayAssociation(model.directConnectGatewayAssociation);
        }

        public final DirectConnectGatewayAssociation.Builder getDirectConnectGatewayAssociation() {
            return directConnectGatewayAssociation != null ? directConnectGatewayAssociation.toBuilder() : null;
        }

        @Override
        public final Builder directConnectGatewayAssociation(DirectConnectGatewayAssociation directConnectGatewayAssociation) {
            this.directConnectGatewayAssociation = directConnectGatewayAssociation;
            return this;
        }

        public final void setDirectConnectGatewayAssociation(
                DirectConnectGatewayAssociation.BuilderImpl directConnectGatewayAssociation) {
            this.directConnectGatewayAssociation = directConnectGatewayAssociation != null ? directConnectGatewayAssociation
                    .build() : null;
        }

        @Override
        public DeleteDirectConnectGatewayAssociationResponse build() {
            return new DeleteDirectConnectGatewayAssociationResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
