/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AllocatePublicVirtualInterfaceRequest extends DirectConnectRequest implements
        ToCopyableBuilder<AllocatePublicVirtualInterfaceRequest.Builder, AllocatePublicVirtualInterfaceRequest> {
    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AllocatePublicVirtualInterfaceRequest::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final SdkField<String> OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AllocatePublicVirtualInterfaceRequest::ownerAccount)).setter(setter(Builder::ownerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerAccount").build()).build();

    private static final SdkField<NewPublicVirtualInterfaceAllocation> NEW_PUBLIC_VIRTUAL_INTERFACE_ALLOCATION_FIELD = SdkField
            .<NewPublicVirtualInterfaceAllocation> builder(MarshallingType.SDK_POJO)
            .getter(getter(AllocatePublicVirtualInterfaceRequest::newPublicVirtualInterfaceAllocation))
            .setter(setter(Builder::newPublicVirtualInterfaceAllocation))
            .constructor(NewPublicVirtualInterfaceAllocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("newPublicVirtualInterfaceAllocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ID_FIELD,
            OWNER_ACCOUNT_FIELD, NEW_PUBLIC_VIRTUAL_INTERFACE_ALLOCATION_FIELD));

    private final String connectionId;

    private final String ownerAccount;

    private final NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation;

    private AllocatePublicVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.connectionId = builder.connectionId;
        this.ownerAccount = builder.ownerAccount;
        this.newPublicVirtualInterfaceAllocation = builder.newPublicVirtualInterfaceAllocation;
    }

    /**
     * <p>
     * The ID of the connection on which the public virtual interface is provisioned.
     * </p>
     * 
     * @return The ID of the connection on which the public virtual interface is provisioned.
     */
    public String connectionId() {
        return connectionId;
    }

    /**
     * <p>
     * The ID of the AWS account that owns the public virtual interface.
     * </p>
     * 
     * @return The ID of the AWS account that owns the public virtual interface.
     */
    public String ownerAccount() {
        return ownerAccount;
    }

    /**
     * <p>
     * Information about the public virtual interface.
     * </p>
     * 
     * @return Information about the public virtual interface.
     */
    public NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation() {
        return newPublicVirtualInterfaceAllocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        hashCode = 31 * hashCode + Objects.hashCode(ownerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(newPublicVirtualInterfaceAllocation());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AllocatePublicVirtualInterfaceRequest)) {
            return false;
        }
        AllocatePublicVirtualInterfaceRequest other = (AllocatePublicVirtualInterfaceRequest) obj;
        return Objects.equals(connectionId(), other.connectionId()) && Objects.equals(ownerAccount(), other.ownerAccount())
                && Objects.equals(newPublicVirtualInterfaceAllocation(), other.newPublicVirtualInterfaceAllocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AllocatePublicVirtualInterfaceRequest").add("ConnectionId", connectionId())
                .add("OwnerAccount", ownerAccount())
                .add("NewPublicVirtualInterfaceAllocation", newPublicVirtualInterfaceAllocation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        case "ownerAccount":
            return Optional.ofNullable(clazz.cast(ownerAccount()));
        case "newPublicVirtualInterfaceAllocation":
            return Optional.ofNullable(clazz.cast(newPublicVirtualInterfaceAllocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AllocatePublicVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((AllocatePublicVirtualInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AllocatePublicVirtualInterfaceRequest> {
        /**
         * <p>
         * The ID of the connection on which the public virtual interface is provisioned.
         * </p>
         * 
         * @param connectionId
         *        The ID of the connection on which the public virtual interface is provisioned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        /**
         * <p>
         * The ID of the AWS account that owns the public virtual interface.
         * </p>
         * 
         * @param ownerAccount
         *        The ID of the AWS account that owns the public virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAccount(String ownerAccount);

        /**
         * <p>
         * Information about the public virtual interface.
         * </p>
         * 
         * @param newPublicVirtualInterfaceAllocation
         *        Information about the public virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation);

        /**
         * <p>
         * Information about the public virtual interface.
         * </p>
         * This is a convenience that creates an instance of the {@link NewPublicVirtualInterfaceAllocation.Builder}
         * avoiding the need to create one manually via {@link NewPublicVirtualInterfaceAllocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link NewPublicVirtualInterfaceAllocation.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #newPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation)}.
         * 
         * @param newPublicVirtualInterfaceAllocation
         *        a consumer that will call methods on {@link NewPublicVirtualInterfaceAllocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #newPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation)
         */
        default Builder newPublicVirtualInterfaceAllocation(
                Consumer<NewPublicVirtualInterfaceAllocation.Builder> newPublicVirtualInterfaceAllocation) {
            return newPublicVirtualInterfaceAllocation(NewPublicVirtualInterfaceAllocation.builder()
                    .applyMutation(newPublicVirtualInterfaceAllocation).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String connectionId;

        private String ownerAccount;

        private NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation;

        private BuilderImpl() {
        }

        private BuilderImpl(AllocatePublicVirtualInterfaceRequest model) {
            super(model);
            connectionId(model.connectionId);
            ownerAccount(model.ownerAccount);
            newPublicVirtualInterfaceAllocation(model.newPublicVirtualInterfaceAllocation);
        }

        public final String getConnectionId() {
            return connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        public final String getOwnerAccount() {
            return ownerAccount;
        }

        @Override
        public final Builder ownerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
            return this;
        }

        public final void setOwnerAccount(String ownerAccount) {
            this.ownerAccount = ownerAccount;
        }

        public final NewPublicVirtualInterfaceAllocation.Builder getNewPublicVirtualInterfaceAllocation() {
            return newPublicVirtualInterfaceAllocation != null ? newPublicVirtualInterfaceAllocation.toBuilder() : null;
        }

        @Override
        public final Builder newPublicVirtualInterfaceAllocation(
                NewPublicVirtualInterfaceAllocation newPublicVirtualInterfaceAllocation) {
            this.newPublicVirtualInterfaceAllocation = newPublicVirtualInterfaceAllocation;
            return this;
        }

        public final void setNewPublicVirtualInterfaceAllocation(
                NewPublicVirtualInterfaceAllocation.BuilderImpl newPublicVirtualInterfaceAllocation) {
            this.newPublicVirtualInterfaceAllocation = newPublicVirtualInterfaceAllocation != null ? newPublicVirtualInterfaceAllocation
                    .build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AllocatePublicVirtualInterfaceRequest build() {
            return new AllocatePublicVirtualInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
