/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.directconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateVirtualInterfaceRequest extends DirectConnectRequest implements
        ToCopyableBuilder<AssociateVirtualInterfaceRequest.Builder, AssociateVirtualInterfaceRequest> {
    private static final SdkField<String> VIRTUAL_INTERFACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateVirtualInterfaceRequest::virtualInterfaceId)).setter(setter(Builder::virtualInterfaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("virtualInterfaceId").build())
            .build();

    private static final SdkField<String> CONNECTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AssociateVirtualInterfaceRequest::connectionId)).setter(setter(Builder::connectionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VIRTUAL_INTERFACE_ID_FIELD,
            CONNECTION_ID_FIELD));

    private final String virtualInterfaceId;

    private final String connectionId;

    private AssociateVirtualInterfaceRequest(BuilderImpl builder) {
        super(builder);
        this.virtualInterfaceId = builder.virtualInterfaceId;
        this.connectionId = builder.connectionId;
    }

    /**
     * <p>
     * The ID of the virtual interface.
     * </p>
     * 
     * @return The ID of the virtual interface.
     */
    public String virtualInterfaceId() {
        return virtualInterfaceId;
    }

    /**
     * <p>
     * The ID of the LAG or connection.
     * </p>
     * 
     * @return The ID of the LAG or connection.
     */
    public String connectionId() {
        return connectionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(virtualInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(connectionId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateVirtualInterfaceRequest)) {
            return false;
        }
        AssociateVirtualInterfaceRequest other = (AssociateVirtualInterfaceRequest) obj;
        return Objects.equals(virtualInterfaceId(), other.virtualInterfaceId())
                && Objects.equals(connectionId(), other.connectionId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AssociateVirtualInterfaceRequest").add("VirtualInterfaceId", virtualInterfaceId())
                .add("ConnectionId", connectionId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "virtualInterfaceId":
            return Optional.ofNullable(clazz.cast(virtualInterfaceId()));
        case "connectionId":
            return Optional.ofNullable(clazz.cast(connectionId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateVirtualInterfaceRequest, T> g) {
        return obj -> g.apply((AssociateVirtualInterfaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DirectConnectRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, AssociateVirtualInterfaceRequest> {
        /**
         * <p>
         * The ID of the virtual interface.
         * </p>
         * 
         * @param virtualInterfaceId
         *        The ID of the virtual interface.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder virtualInterfaceId(String virtualInterfaceId);

        /**
         * <p>
         * The ID of the LAG or connection.
         * </p>
         * 
         * @param connectionId
         *        The ID of the LAG or connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionId(String connectionId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DirectConnectRequest.BuilderImpl implements Builder {
        private String virtualInterfaceId;

        private String connectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateVirtualInterfaceRequest model) {
            super(model);
            virtualInterfaceId(model.virtualInterfaceId);
            connectionId(model.connectionId);
        }

        public final String getVirtualInterfaceId() {
            return virtualInterfaceId;
        }

        @Override
        public final Builder virtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
            return this;
        }

        public final void setVirtualInterfaceId(String virtualInterfaceId) {
            this.virtualInterfaceId = virtualInterfaceId;
        }

        public final String getConnectionId() {
            return connectionId;
        }

        @Override
        public final Builder connectionId(String connectionId) {
            this.connectionId = connectionId;
            return this;
        }

        public final void setConnectionId(String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateVirtualInterfaceRequest build() {
            return new AssociateVirtualInterfaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
